/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization;

import com.orientechnologies.common.serialization.OBinaryConverter;

public class OSafeBinaryConverter
implements OBinaryConverter {
    @Override
    public void putShort(byte[] buffer, int index, short value) {
        OSafeBinaryConverter.short2bytes(value, buffer, index);
    }

    @Override
    public short getShort(byte[] buffer, int index) {
        return OSafeBinaryConverter.bytes2short(buffer, index);
    }

    @Override
    public void putInt(byte[] buffer, int pointer, int value) {
        OSafeBinaryConverter.int2bytes(value, buffer, pointer);
    }

    @Override
    public int getInt(byte[] buffer, int pointer) {
        return OSafeBinaryConverter.bytes2int(buffer, pointer);
    }

    @Override
    public void putLong(byte[] buffer, int index, long value) {
        OSafeBinaryConverter.long2bytes(value, buffer, index);
    }

    @Override
    public long getLong(byte[] buffer, int index) {
        return OSafeBinaryConverter.bytes2long(buffer, index);
    }

    @Override
    public void putChar(byte[] buffer, int index, char character) {
        buffer[index] = (byte)(character >>> 8);
        buffer[index + 1] = (byte)character;
    }

    @Override
    public char getChar(byte[] buffer, int index) {
        return (char)(((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF));
    }

    @Override
    public boolean nativeAccelerationUsed() {
        return false;
    }

    private static byte[] short2bytes(short value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value & 0xFF);
        return b;
    }

    private static short bytes2short(byte[] b, int offset) {
        return (short)(b[offset] << 8 | b[offset + 1] & 0xFF);
    }

    private static int bytes2int(byte[] b, int offset) {
        return b[offset] << 24 | (0xFF & b[offset + 1]) << 16 | (0xFF & b[offset + 2]) << 8 | 0xFF & b[offset + 3];
    }

    private static byte[] int2bytes(int value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 24 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value >>> 16 & 0xFF);
        b[iBeginOffset + 2] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset + 3] = (byte)(value & 0xFF);
        return b;
    }

    private static byte[] long2bytes(long value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 56 & 0xFFL);
        b[iBeginOffset + 1] = (byte)(value >>> 48 & 0xFFL);
        b[iBeginOffset + 2] = (byte)(value >>> 40 & 0xFFL);
        b[iBeginOffset + 3] = (byte)(value >>> 32 & 0xFFL);
        b[iBeginOffset + 4] = (byte)(value >>> 24 & 0xFFL);
        b[iBeginOffset + 5] = (byte)(value >>> 16 & 0xFFL);
        b[iBeginOffset + 6] = (byte)(value >>> 8 & 0xFFL);
        b[iBeginOffset + 7] = (byte)(value & 0xFFL);
        return b;
    }

    private static long bytes2long(byte[] b, int offset) {
        return (long)(0xFF & b[offset + 7] | (0xFF & b[offset + 6]) << 8 | (0xFF & b[offset + 5]) << 16) | (long)(0xFF & b[offset + 4]) << 24 | (long)(0xFF & b[offset + 3]) << 32 | (long)(0xFF & b[offset + 2]) << 40 | (long)(0xFF & b[offset + 1]) << 48 | (long)(0xFF & b[offset]) << 56;
    }
}

