/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class OIOUtils {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long YEAR = 31536000000L;
    public static final long WEEK = 604800000L;

    public static byte[] toStream(Externalizable iSource) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        iSource.writeExternal(oos);
        oos.flush();
        stream.flush();
        return stream.toByteArray();
    }

    public static long getTimeAsMillisecs(Object iSize) {
        if (iSize == null) {
            throw new IllegalArgumentException("Time is null");
        }
        if (iSize instanceof Number) {
            return ((Number)iSize).longValue();
        }
        String time = iSize.toString();
        boolean number = true;
        for (int i = time.length() - 1; i >= 0; --i) {
            if (Character.isDigit(time.charAt(i))) continue;
            number = false;
            break;
        }
        if (number) {
            return Long.parseLong(time);
        }
        time = time.toUpperCase(Locale.ENGLISH);
        int pos = time.indexOf("MS");
        String timeAsNumber = time.replaceAll("[^\\d]", "");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber);
        }
        pos = time.indexOf("S");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 1000L;
        }
        pos = time.indexOf("M");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 60000L;
        }
        pos = time.indexOf("H");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 3600000L;
        }
        pos = time.indexOf("D");
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 86400000L;
        }
        pos = time.indexOf(87);
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 604800000L;
        }
        pos = time.indexOf(89);
        if (pos > -1) {
            return Long.parseLong(timeAsNumber) * 31536000000L;
        }
        throw new IllegalArgumentException("Time '" + time + "' has a unrecognizable format");
    }

    public static String getTimeAsString(long iTime) {
        if (iTime > 31536000000L && iTime % 31536000000L == 0L) {
            return String.format("%dy", iTime / 31536000000L);
        }
        if (iTime > 604800000L && iTime % 604800000L == 0L) {
            return String.format("%dw", iTime / 604800000L);
        }
        if (iTime > 86400000L && iTime % 86400000L == 0L) {
            return String.format("%dd", iTime / 86400000L);
        }
        if (iTime > 3600000L && iTime % 3600000L == 0L) {
            return String.format("%dh", iTime / 3600000L);
        }
        if (iTime > 60000L && iTime % 60000L == 0L) {
            return String.format("%dm", iTime / 60000L);
        }
        if (iTime > 1000L && iTime % 1000L == 0L) {
            return String.format("%ds", iTime / 1000L);
        }
        return String.format("%dms", iTime);
    }

    public static Date getTodayWithTime(String iTime) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        long today = System.currentTimeMillis();
        Date rslt = new Date();
        rslt.setTime(today - today % 86400000L + df.parse(iTime).getTime());
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File iFile) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(iFile));
        try {
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
        }
        finally {
            reader.close();
        }
        return fileData.toString();
    }

    public static String getUnixFileName(String iFileName) {
        return iFileName != null ? iFileName.replace('\\', '/') : null;
    }

    public static String getRelativePathIfAny(String iDatabaseURL, String iBasePath) {
        if (iBasePath == null) {
            int pos = iDatabaseURL.lastIndexOf(47);
            if (pos > -1) {
                return iDatabaseURL.substring(pos + 1);
            }
        } else {
            int pos = iDatabaseURL.indexOf(iBasePath);
            if (pos > -1) {
                return iDatabaseURL.substring(pos + iBasePath.length() + 1);
            }
        }
        return iDatabaseURL;
    }

    public static String getDatabaseNameFromPath(String iPath) {
        return iPath.replace('/', '$');
    }

    public static String getPathFromDatabaseName(String iPath) {
        return iPath.replace('$', '/');
    }
}

