/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import java.util.Arrays;

public class OBuddyMemory
implements ODirectMemory {
    private static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    public static final int SYSTEM_INFO_SIZE = 2;
    private static final int TAG_OFFSET = 0;
    public static final int SIZE_OFFSET = 1;
    public static final int NEXT_OFFSET = 2;
    public static final int PREVIOUS_OFFSET = 6;
    public static final byte TAG_FREE = 0;
    public static final byte TAG_ALLOCATED = 1;
    private final byte[] buffer;
    private final int minChunkSize;
    private final int[] freeListHeader;
    private final int[] freeListTail;
    private final int maxLevel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBuddyMemory(int capacity, int minChunkSize) {
        OBuddyMemory oBuddyMemory = this;
        synchronized (oBuddyMemory) {
            this.minChunkSize = minChunkSize = (int)Math.pow(2.0, (int)Math.ceil(Math.log(minChunkSize) / Math.log(2.0)));
            capacity = (int)Math.floor(capacity / minChunkSize) * minChunkSize + 1;
            this.maxLevel = (int)(Math.log((double)capacity / (double)minChunkSize) / Math.log(2.0));
            this.freeListHeader = new int[this.maxLevel + 1];
            this.freeListTail = new int[this.maxLevel + 1];
            this.buffer = new byte[capacity];
            this.initMemory();
        }
    }

    @Override
    public synchronized int allocate(byte[] bytes) {
        int pointer = this.allocate(bytes.length);
        if (pointer != -1) {
            this.set(pointer, 0, bytes.length, bytes);
        }
        return pointer;
    }

    @Override
    public synchronized int allocate(int size) {
        int level = 32 - Integer.numberOfLeadingZeros((size + 2 - 1) / this.minChunkSize);
        if (level > this.maxLevel) {
            return -1;
        }
        int pointer = this.freeListHeader[level];
        if (pointer != -1) {
            this.removeNodeFromHead(level);
            this.buffer[pointer] = 1;
        } else {
            int currentLevel = level + 1;
            while (this.freeListHeader[currentLevel] == -1) {
                if (++currentLevel <= this.maxLevel) continue;
                return -1;
            }
            pointer = this.removeNodeFromHead(currentLevel);
            do {
                pointer = this.split(pointer);
                this.buffer[pointer + 0] = --currentLevel == level ? (byte)1 : 0;
                this.buffer[pointer + 1] = (byte)(currentLevel & 0xFF);
            } while (currentLevel > level);
        }
        return pointer;
    }

    @Override
    public synchronized void free(int pointer) {
        int level = this.buffer[pointer + 1];
        int buddy = this.buddy(pointer, level);
        while (level < this.maxLevel && this.buffer[buddy + 0] == 0 && this.buffer[buddy + 1] == level) {
            this.removeFromFreeList(level, buddy);
            if (buddy < pointer) {
                pointer = buddy;
            }
            buddy = this.buddy(pointer, ++level);
        }
        this.buffer[pointer + 0] = 0;
        this.buffer[pointer + 1] = (byte)(level & 0xFF);
        this.addNodeToTail(level, pointer);
    }

    @Override
    public int getActualSpace(int pointer) {
        return (1 << this.buffer[pointer + 1]) * this.minChunkSize;
    }

    @Override
    public byte[] get(int pointer, int offset, int length) {
        int newLength = length > 0 ? Math.min(length, this.size(pointer) - offset) : this.size(pointer) - offset;
        byte[] dest = new byte[newLength];
        System.arraycopy(this.buffer, pointer + 2 + offset, dest, 0, newLength);
        return dest;
    }

    @Override
    public void set(int pointer, int offset, int length, byte[] content) {
        System.arraycopy(content, 0, this.buffer, pointer + 2 + offset, length);
    }

    @Override
    public <T> T get(int pointer, int offset, OBinarySerializer<T> serializer) {
        return serializer.deserializeNative(this.buffer, pointer + 2 + offset);
    }

    @Override
    public <T> void set(int pointer, int offset, T data, OBinarySerializer<T> serializer) {
        serializer.serializeNative(data, this.buffer, pointer + 2 + offset);
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public synchronized int freeSpace() {
        int freeSpace = 0;
        for (int level = 0; level <= this.maxLevel; ++level) {
            int count = 0;
            int pointer = this.freeListHeader[level];
            while (pointer != -1) {
                ++count;
                pointer = this.next(pointer);
            }
            freeSpace += (1 << level) * count;
        }
        return freeSpace *= this.minChunkSize;
    }

    @Override
    public synchronized void clear() {
        this.initMemory();
    }

    @Override
    public void setInt(int pointer, int offset, int value) {
        this.writeInt(pointer, offset + 2, value);
    }

    @Override
    public int getInt(int pointer, int offset) {
        return this.readInt(pointer, offset + 2);
    }

    @Override
    public long getLong(int pointer, int offset) {
        return CONVERTER.getLong(this.buffer, pointer + offset + 2);
    }

    @Override
    public void setLong(int pointer, int offset, long value) {
        CONVERTER.putLong(this.buffer, pointer + offset + 2, value);
    }

    @Override
    public byte getByte(int pointer, int offset) {
        int index = pointer + offset + 2;
        return this.buffer[index];
    }

    @Override
    public void setByte(int pointer, int offset, byte value) {
        int index = pointer + offset + 2;
        this.buffer[index] = value;
    }

    @Override
    public void copyData(int srcPointer, int fromOffset, int destPointer, int toOffset, int len) {
        int fromIndex = srcPointer + fromOffset + 2;
        int toIndex = destPointer + toOffset + 2;
        System.arraycopy(this.buffer, fromIndex, this.buffer, toIndex, len);
    }

    private void initMemory() {
        Arrays.fill(this.freeListHeader, 0, this.maxLevel + 1, -1);
        Arrays.fill(this.freeListTail, 0, this.maxLevel + 1, -1);
        int pointer = 0;
        int availSpace = this.buffer.length;
        for (byte level = (byte)this.maxLevel; level >= 0; level = (byte)(level - 1)) {
            int chunkSize = (1 << level) * this.minChunkSize;
            if (availSpace <= chunkSize) continue;
            this.buffer[pointer + 0] = 0;
            this.buffer[pointer + 1] = level;
            this.addNodeToTail(level, pointer);
            availSpace -= chunkSize;
            pointer = this.buddy(pointer, level);
        }
        assert (availSpace == 1);
        this.buffer[pointer + 0] = 1;
    }

    private int split(int pointer) {
        int n = pointer + 1;
        byte by = (byte)(this.buffer[n] - 1);
        this.buffer[n] = by;
        byte level = by;
        this.addNodeToTail(level, pointer);
        return this.buddy(pointer, level);
    }

    private int size(int pointer) {
        return (1 << this.buffer[pointer + 1]) * this.minChunkSize - 2;
    }

    private int buddy(int pointer, int level) {
        return pointer ^ (1 << level) * this.minChunkSize;
    }

    private int removeNodeFromHead(int level) {
        int pointer = this.freeListHeader[level];
        this.freeListHeader[level] = this.next(pointer);
        if (this.freeListHeader[level] != -1) {
            this.previous(this.freeListHeader[level], -1);
        } else {
            this.freeListTail[level] = -1;
        }
        return pointer;
    }

    private void addNodeToTail(int level, int pointer) {
        this.next(pointer, -1);
        this.previous(pointer, this.freeListTail[level]);
        if (this.freeListTail[level] == -1) {
            this.freeListHeader[level] = pointer;
        } else {
            this.next(this.freeListTail[level], pointer);
        }
        this.freeListTail[level] = pointer;
    }

    private void removeFromFreeList(int level, int pointer) {
        int next = this.next(pointer);
        int previous = this.previous(pointer);
        if (this.freeListHeader[level] == pointer) {
            this.freeListHeader[level] = next;
        } else {
            this.next(previous, next);
        }
        if (this.freeListTail[level] == pointer) {
            this.freeListTail[level] = previous;
        } else {
            this.previous(next, previous);
        }
    }

    private int next(int pointer) {
        return this.readInt(pointer, 2);
    }

    private void next(int pointer, int next) {
        this.writeInt(pointer, 2, next);
    }

    private int previous(int pointer) {
        return this.readInt(pointer, 6);
    }

    private void previous(int pointer, int previous) {
        this.writeInt(pointer, 6, previous);
    }

    private void writeInt(int pointer, int offset, int value) {
        CONVERTER.putInt(this.buffer, pointer + offset, value);
    }

    private int readInt(int pointer, int offset) {
        return CONVERTER.getInt(this.buffer, pointer + offset);
    }
}

