/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.DefaultConsoleReader;
import com.orientechnologies.common.console.OConsoleCommandCollection;
import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.util.OArrays;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;

public class OConsoleApplication {
    protected InputStream in = System.in;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    protected String lineSeparator = "\n";
    protected String commandSeparator = ";";
    protected String wordSeparator = " ";
    protected String[] helpCommands = new String[]{"help", "?"};
    protected String[] exitCommands = new String[]{"exit", "bye", "quit"};
    protected Map<String, String> properties = new HashMap<String, String>();
    protected OConsoleReader reader = new DefaultConsoleReader();
    protected boolean interactiveMode;
    protected String[] args;
    protected static final String COMMENT_PREFIX = "#";

    public void setReader(OConsoleReader iReader) {
        this.reader = iReader;
        this.reader.setConsole(this);
    }

    public OConsoleApplication(String[] iArgs) {
        this.args = iArgs;
    }

    public int run() {
        this.interactiveMode = this.isInteractiveMode(this.args);
        this.onBefore();
        int result = 0;
        if (this.interactiveMode) {
            String consoleInput;
            do {
                this.out.println();
                this.out.print("orientdb> ");
            } while ((consoleInput = this.reader.readLine()) == null || consoleInput.length() == 0 || this.executeCommands(new Scanner(consoleInput), false));
        } else {
            result = this.executeBatch(this.getCommandLine(this.args)) ? 0 : 1;
        }
        this.onAfter();
        return result;
    }

    protected boolean isInteractiveMode(String[] args) {
        return args.length == 0;
    }

    protected boolean executeBatch(String commandLine) {
        File commandFile = new File(commandLine);
        Scanner scanner = null;
        try {
            scanner = new Scanner(commandFile);
        }
        catch (FileNotFoundException e) {
            scanner = new Scanner(commandLine);
        }
        return this.executeCommands(scanner, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeCommands(Scanner iScanner, boolean iExitOnException) {
        StringBuilder commandBuffer = new StringBuilder();
        try {
            RESULT status;
            String commandLine = null;
            iScanner.useDelimiter(this.commandSeparator);
            while (iScanner.hasNext()) {
                commandLine = iScanner.next().trim();
                if (commandLine.startsWith("--") || commandLine.startsWith("//")) continue;
                if (commandLine.startsWith("js")) {
                    commandBuffer.append(commandLine);
                    commandLine = null;
                } else if (commandLine.startsWith("end") && commandBuffer.length() > 0) {
                    commandLine = commandBuffer.toString();
                    commandBuffer.setLength(0);
                } else if (commandBuffer.length() > 0) {
                    commandBuffer.append(';');
                    commandBuffer.append(commandLine);
                    commandLine = null;
                }
                if (commandLine == null) continue;
                status = this.execute(commandLine);
                commandLine = null;
                if (status != RESULT.EXIT && (status != RESULT.ERROR || !iExitOnException)) continue;
                boolean bl = false;
                return bl;
            }
            if (commandBuffer.length() > 0 && ((status = this.execute(commandBuffer.toString())) == RESULT.EXIT || status == RESULT.ERROR && iExitOnException)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            iScanner.close();
        }
        return true;
    }

    protected RESULT execute(String iCommand) {
        if ((iCommand = iCommand.trim()).length() == 0) {
            return RESULT.OK;
        }
        if (iCommand.startsWith(COMMENT_PREFIX)) {
            return RESULT.OK;
        }
        String[] commandWords = OStringParser.getWords(iCommand, this.wordSeparator);
        for (String cmd : this.helpCommands) {
            if (!cmd.equals(commandWords[0])) continue;
            this.help();
            return RESULT.OK;
        }
        for (String cmd : this.exitCommands) {
            if (!cmd.equals(commandWords[0])) continue;
            return RESULT.EXIT;
        }
        Method lastMethodInvoked = null;
        StringBuilder lastCommandInvoked = new StringBuilder();
        String commandLowerCase = iCommand.toLowerCase();
        for (Map.Entry<Method, Object> entry : this.getConsoleMethods().entrySet()) {
            Object[] methodArgs;
            Method m = entry.getKey();
            String methodName = m.getName();
            ConsoleCommand ann = m.getAnnotation(ConsoleCommand.class);
            StringBuilder commandName = new StringBuilder();
            int commandWordCount = 1;
            for (int i = 0; i < methodName.length(); ++i) {
                char ch = methodName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    commandName.append(" ");
                    ch = Character.toLowerCase(ch);
                    ++commandWordCount;
                }
                commandName.append(ch);
            }
            if (!commandLowerCase.equals(commandName.toString()) && !commandLowerCase.startsWith(commandName.toString() + " ")) {
                String[] aliases;
                if (ann == null || (aliases = ann.aliases()) == null || aliases.length == 0) continue;
                boolean aliasMatch = false;
                for (String alias : aliases) {
                    if (!iCommand.startsWith(alias.split(" ")[0])) continue;
                    aliasMatch = true;
                    commandWordCount = 1;
                    break;
                }
                if (!aliasMatch) continue;
            }
            if (ann != null && !ann.splitInWords()) {
                methodArgs = new String[]{iCommand.substring(iCommand.indexOf(32) + 1)};
            } else {
                if (m.getParameterTypes().length > commandWords.length - commandWordCount) {
                    block8: for (int paramNum = m.getParameterAnnotations().length - 1; paramNum > -1; --paramNum) {
                        Annotation[] paramAnn = m.getParameterAnnotations()[paramNum];
                        if (paramAnn == null) continue;
                        for (int annNum = paramAnn.length - 1; annNum > -1; --annNum) {
                            if (!(paramAnn[annNum] instanceof ConsoleParameter)) continue;
                            ConsoleParameter annotation = (ConsoleParameter)paramAnn[annNum];
                            if (!annotation.optional()) continue block8;
                            commandWords = OArrays.copyOf(commandWords, commandWords.length + 1);
                            continue block8;
                        }
                    }
                }
                methodArgs = OArrays.copyOfRange(commandWords, commandWordCount, commandWords.length);
            }
            try {
                m.invoke(entry.getValue(), methodArgs);
            }
            catch (IllegalArgumentException e) {
                lastMethodInvoked = m;
                lastCommandInvoked.setLength(0);
                for (int i = 0; i < commandWordCount; ++i) {
                    if (lastCommandInvoked.length() > 0) {
                        lastCommandInvoked.append(" ");
                    }
                    lastCommandInvoked.append(commandWords[i]);
                }
                continue;
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    this.onException(e.getCause());
                } else {
                    e.printStackTrace();
                }
                return RESULT.ERROR;
            }
            return RESULT.OK;
        }
        if (lastMethodInvoked != null) {
            this.syntaxError(lastCommandInvoked.toString(), lastMethodInvoked);
        }
        this.out.println("!Unrecognized command: '" + iCommand + "'");
        return RESULT.ERROR;
    }

    protected void syntaxError(String iCommand, Method m) {
        this.out.print("!Wrong syntax. If you're using a file make sure all commands are delimited by ';'\n\r\n\r Expected: " + iCommand + " ");
        String paramName = null;
        String paramDescription = null;
        boolean paramOptional = false;
        StringBuilder buffer = new StringBuilder("\n\nWhere:\n\n");
        Annotation[][] arr$ = m.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation ann : annotations = arr$[i$]) {
                if (!(ann instanceof ConsoleParameter)) continue;
                paramName = ((ConsoleParameter)ann).name();
                paramDescription = ((ConsoleParameter)ann).description();
                paramOptional = ((ConsoleParameter)ann).optional();
                break;
            }
            if (paramName == null) {
                paramName = "?";
            }
            if (paramOptional) {
                this.out.print("[<" + paramName + ">] ");
            } else {
                this.out.print("<" + paramName + "> ");
            }
            buffer.append("* ");
            buffer.append(String.format("%-15s", paramName));
            if (paramDescription != null) {
                buffer.append(String.format("%-15s", paramDescription));
            }
            buffer.append("\n");
        }
        this.out.println(buffer);
    }

    protected Map<Method, Object> getConsoleMethods() {
        Iterator<OConsoleCommandCollection> ite = ServiceRegistry.lookupProviders(OConsoleCommandCollection.class);
        ArrayList<Object> candidates = new ArrayList<Object>();
        candidates.add(this);
        while (ite.hasNext()) {
            try {
                OConsoleCommandCollection cc = (OConsoleCommandCollection)ite.next().getClass().newInstance();
                cc.setContext(this);
                candidates.add(cc);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(OConsoleApplication.class.getName()).log(Level.WARNING, ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(OConsoleApplication.class.getName()).log(Level.WARNING, ex.getMessage());
            }
        }
        TreeMap<Method, Object> consoleMethods = new TreeMap<Method, Object>(new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Object e : candidates) {
            Method[] methods;
            for (Method m : methods = e.getClass().getMethods()) {
                if (Modifier.isAbstract(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || m.getReturnType() != Void.TYPE) continue;
                consoleMethods.put(m, e);
            }
        }
        return consoleMethods;
    }

    protected Map<String, Object> addCommand(Map<String, Object> commandsTree, String commandLine) {
        return commandsTree;
    }

    protected void help() {
        this.out.println();
        this.out.println("AVAILABLE COMMANDS:");
        this.out.println();
        for (Method m : this.getConsoleMethods().keySet()) {
            ConsoleCommand annotation = m.getAnnotation(ConsoleCommand.class);
            if (annotation == null) continue;
            System.out.print(String.format("* %-70s%s\n", OConsoleApplication.getCorrectMethodName(m), annotation.description()));
        }
        System.out.print(String.format("* %-70s%s\n", OConsoleApplication.getClearName("help"), "Print this help"));
        System.out.print(String.format("* %-70s%s\n", OConsoleApplication.getClearName("exit"), "Close the console"));
    }

    public static String getCorrectMethodName(Method m) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OConsoleApplication.getClearName(m.getName()));
        for (int i = 0; i < m.getParameterAnnotations().length; ++i) {
            for (int j = 0; j < m.getParameterAnnotations()[i].length; ++j) {
                if (!(m.getParameterAnnotations()[i][j] instanceof ConsoleParameter)) continue;
                buffer.append(" <" + ((ConsoleParameter)m.getParameterAnnotations()[i][j]).name() + ">");
            }
        }
        return buffer.toString();
    }

    public static String getClearName(String iJavaName) {
        StringBuilder buffer = new StringBuilder();
        if (iJavaName != null) {
            buffer.append(iJavaName.charAt(0));
            for (int i = 1; i < iJavaName.length(); ++i) {
                char c = iJavaName.charAt(i);
                if (Character.isUpperCase(c)) {
                    buffer.append(' ');
                }
                buffer.append(Character.toLowerCase(c));
            }
        }
        return buffer.toString();
    }

    protected String getCommandLine(String[] iArguments) {
        StringBuilder command = new StringBuilder();
        for (int i = 0; i < iArguments.length; ++i) {
            if (i > 0) {
                command.append(" ");
            }
            command.append(iArguments[i]);
        }
        return command.toString();
    }

    protected void onBefore() {
    }

    protected void onAfter() {
    }

    protected void onException(Throwable throwable) {
        throwable.printStackTrace();
    }

    protected static enum RESULT {
        OK,
        ERROR,
        EXIT;

    }
}

