/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OIterableObjectArray;
import com.orientechnologies.common.log.OLogManager;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class OMultiValue {
    public static boolean isMultiValue(Class<?> iType) {
        return iType.isArray() || Collection.class.isAssignableFrom(iType) || Map.class.isAssignableFrom(iType);
    }

    public static boolean isMultiValue(Object iObject) {
        return iObject == null ? false : OMultiValue.isMultiValue(iObject.getClass());
    }

    public static boolean isIterable(Object iObject) {
        return iObject == null ? false : (iObject instanceof Iterable ? true : iObject instanceof Iterator);
    }

    public static int getSize(Object iObject) {
        if (iObject == null) {
            return 0;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return 0;
        }
        if (iObject instanceof Collection) {
            return ((Collection)iObject).size();
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).size();
        }
        if (iObject.getClass().isArray()) {
            return Array.getLength(iObject);
        }
        return 0;
    }

    public static Object getFirstValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject) || OMultiValue.getSize(iObject) == 0) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(0);
            }
            if (iObject instanceof Collection) {
                return ((Collection)iObject).iterator().next();
            }
            if (iObject instanceof Map) {
                return ((Map)iObject).values().iterator().next();
            }
            if (iObject.getClass().isArray()) {
                return Array.get(iObject, 0);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the first item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Object getLastValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(((List)iObject).size() - 1);
            }
            if (iObject instanceof Collection) {
                Object last = null;
                for (Object o : (Collection)iObject) {
                    last = o;
                }
                return last;
            }
            if (iObject instanceof Map) {
                Object last = null;
                for (Object o : ((Map)iObject).values()) {
                    last = o;
                }
                return last;
            }
            if (iObject.getClass().isArray()) {
                return Array.get(iObject, Array.getLength(iObject) - 1);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the last item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Object getValue(Object iObject, int iIndex) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        if (iIndex > OMultiValue.getSize(iObject)) {
            return null;
        }
        try {
            if (iObject instanceof List) {
                return ((List)iObject).get(iIndex);
            }
            if (iObject instanceof Set) {
                int i = 0;
                for (Object o : (Set)iObject) {
                    if (i++ != iIndex) continue;
                    return o;
                }
            } else if (iObject instanceof Map) {
                int i = 0;
                for (Object o : ((Map)iObject).values()) {
                    if (i++ != iIndex) continue;
                    return o;
                }
            } else if (iObject.getClass().isArray()) {
                return Array.get(iObject, 0);
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(iObject, "Error on reading the first item of the Multi-value field '%s'", iObject);
        }
        return null;
    }

    public static Iterable<Object> getMultiValueIterable(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof Collection) {
            return (Collection)iObject;
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).values();
        }
        if (iObject.getClass().isArray()) {
            return new OIterableObjectArray<Object>(iObject);
        }
        if (iObject instanceof Iterator) {
            ArrayList<Object> temp = new ArrayList<Object>();
            Iterator it = (Iterator)iObject;
            while (it.hasNext()) {
                temp.add(it.next());
            }
            return temp;
        }
        if (iObject instanceof Iterable) {
            return (Iterable)iObject;
        }
        return null;
    }

    public static Iterator<Object> getMultiValueIterator(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(iObject)) {
            return null;
        }
        if (iObject instanceof Collection) {
            return ((Collection)iObject).iterator();
        }
        if (iObject instanceof Map) {
            return ((Map)iObject).values().iterator();
        }
        if (iObject.getClass().isArray()) {
            return new OIterableObjectArray(iObject).iterator();
        }
        return null;
    }

    public static String toString(Object iObject) {
        StringBuilder sb = new StringBuilder();
        if (iObject instanceof Collection) {
            Collection coll = (Collection)iObject;
            sb.append('[');
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                try {
                    Object e = it.next();
                    sb.append((Object)(e == iObject ? "(this Collection)" : e));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                catch (NoSuchElementException ex) {}
            }
            return sb.append(']').toString();
        }
        if (iObject instanceof Map) {
            Map map = (Map)iObject;
            sb.append('{');
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry e = it.next();
                    sb.append((String)e.getKey());
                    sb.append(":");
                    sb.append((Object)(e.getValue() == iObject ? "(this Map)" : e.getValue()));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                catch (NoSuchElementException ex) {}
            }
            return sb.append('}').toString();
        }
        return iObject.toString();
    }
}

