/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OMVRBTree;
import java.util.Map;

public abstract class OMVRBTreeEntry<K, V>
implements Map.Entry<K, V>,
Comparable<OMVRBTreeEntry<K, V>> {
    protected OMVRBTree<K, V> tree;
    private int pageSplitItems;
    public static final int BINARY_SEARCH_THRESHOLD = 10;

    protected OMVRBTreeEntry(OMVRBTree<K, V> iTree) {
        this.tree = iTree;
    }

    public abstract void setLeft(OMVRBTreeEntry<K, V> var1);

    public abstract OMVRBTreeEntry<K, V> getLeft();

    public abstract void setRight(OMVRBTreeEntry<K, V> var1);

    public abstract OMVRBTreeEntry<K, V> getRight();

    public abstract OMVRBTreeEntry<K, V> setParent(OMVRBTreeEntry<K, V> var1);

    public abstract OMVRBTreeEntry<K, V> getParent();

    protected abstract OMVRBTreeEntry<K, V> getLeftInMemory();

    protected abstract OMVRBTreeEntry<K, V> getParentInMemory();

    protected abstract OMVRBTreeEntry<K, V> getRightInMemory();

    protected abstract OMVRBTreeEntry<K, V> getNextInMemory();

    public OMVRBTreeEntry<K, V> getFirstInMemory() {
        OMVRBTreeEntry<K, V> prev = this;
        for (OMVRBTreeEntry<K, V> node = this; node != null; node = node.getPreviousInMemory()) {
            prev = node;
        }
        return prev;
    }

    public OMVRBTreeEntry<K, V> getPreviousInMemory() {
        OMVRBTreeEntry<K, V> t = this;
        OMVRBTreeEntry<K, V> p = null;
        if (t.getLeftInMemory() != null) {
            p = t.getLeftInMemory();
            while (p.getRightInMemory() != null) {
                p = p.getRightInMemory();
            }
        } else {
            for (p = t.getParentInMemory(); p != null && t == p.getLeftInMemory(); p = p.getParentInMemory()) {
                t = p;
            }
        }
        return p;
    }

    protected OMVRBTree<K, V> getTree() {
        return this.tree;
    }

    public int getDepth() {
        int level = 0;
        OMVRBTreeEntry<K, V> entry = this;
        while (entry.getParent() != null) {
            ++level;
            entry = entry.getParent();
        }
        return level;
    }

    @Override
    public K getKey() {
        return this.getKey(this.tree.pageIndex);
    }

    public K getKey(int iIndex) {
        if (iIndex >= this.getSize()) {
            throw new IndexOutOfBoundsException("Requested index " + iIndex + " when the range is 0-" + this.getSize());
        }
        this.tree.pageIndex = iIndex;
        return this.getKeyAt(iIndex);
    }

    protected abstract K getKeyAt(int var1);

    @Override
    public V getValue() {
        if (this.tree.pageIndex == -1) {
            return this.getValueAt(0);
        }
        return this.getValueAt(this.tree.pageIndex);
    }

    public V getValue(int iIndex) {
        this.tree.pageIndex = iIndex;
        return this.getValueAt(iIndex);
    }

    protected abstract V getValueAt(int var1);

    public int getFreeSpace() {
        return this.getPageSize() - this.getSize();
    }

    protected V search(K iKey) {
        this.tree.pageItemFound = false;
        int size = this.getSize();
        if (size == 0) {
            return null;
        }
        this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(iKey, this.getKeyAt(0)) : ((Comparable)iKey).compareTo(this.getKeyAt(0));
        if (this.tree.pageItemComparator == 0) {
            this.tree.pageItemFound = true;
            this.tree.pageIndex = 0;
            return this.getValueAt(this.tree.pageIndex);
        }
        if (this.tree.pageItemComparator < 0) {
            this.tree.pageIndex = 0;
            return null;
        }
        this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(iKey, this.getKeyAt(size - 1)) : ((Comparable)iKey).compareTo(this.getKeyAt(size - 1));
        if (this.tree.pageItemComparator > 0) {
            this.tree.pageIndex = size;
            return null;
        }
        if (size < 10) {
            return this.linearSearch(iKey);
        }
        return this.binarySearch(iKey);
    }

    private V linearSearch(K iKey) {
        int i;
        V value = null;
        this.tree.pageItemComparator = -1;
        int s = this.getSize();
        for (i = 0; i < s; ++i) {
            this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(this.getKeyAt(i), iKey) : ((Comparable)this.getKeyAt(i)).compareTo(iKey);
            if (this.tree.pageItemComparator == 0) {
                this.tree.pageItemFound = true;
                value = this.getValueAt(i);
                break;
            }
            if (this.tree.pageItemComparator > 0) break;
        }
        this.tree.pageIndex = i;
        return value;
    }

    private V binarySearch(K iKey) {
        int low = 0;
        int high = this.getSize() - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            K midVal = this.getKeyAt(mid);
            this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(midVal, iKey) : ((Comparable)midVal).compareTo(iKey);
            if (this.tree.pageItemComparator == 0) {
                this.tree.pageItemFound = true;
                this.tree.pageIndex = mid;
                return this.getValueAt(this.tree.pageIndex);
            }
            if (low == high) break;
            if (this.tree.pageItemComparator < 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        this.tree.pageIndex = mid;
        return null;
    }

    protected abstract void insert(int var1, K var2, V var3);

    protected abstract void remove();

    protected abstract void setColor(boolean var1);

    public abstract boolean getColor();

    public abstract int getSize();

    public K getLastKey() {
        return this.getKey(this.getSize() - 1);
    }

    public K getFirstKey() {
        return this.getKey(0);
    }

    protected abstract void copyFrom(OMVRBTreeEntry<K, V> var1);

    public int getPageSplitItems() {
        return this.pageSplitItems;
    }

    protected void init() {
        this.pageSplitItems = (int)((float)this.getPageSize() * this.tree.pageLoadFactor);
    }

    public abstract int getPageSize();

    @Override
    public int compareTo(OMVRBTreeEntry<K, V> o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        if (this.getSize() == 0) {
            return -1;
        }
        if (o.getSize() == 0) {
            return 1;
        }
        if (this.tree.comparator != null) {
            return this.tree.comparator.compare(this.getFirstKey(), o.getFirstKey());
        }
        return ((Comparable)this.getFirstKey()).compareTo(o.getFirstKey());
    }

    public String toString() {
        int idx = this.tree.pageIndex;
        if (idx > -1 && idx < this.getSize()) {
            return this.getKeyAt(idx) + "=" + this.getValueAt(idx);
        }
        return null;
    }
}

