/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKCS12ShroudedKeyBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private char[] passwd;
    private PrivateKeyPKCS8 pkcs8;
    private ASN1Sequence contents;
    private static final ASN1ObjectID OID = new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2);

    public PKCS12ShroudedKeyBag() {
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe parent) {
        this.parent = parent;
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe parent, PrivateKeyPKCS8 pkcs8) {
        this(parent);
        this.setPKCS8_FIPS(pkcs8);
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe parent, ASN1Sequence s) throws IOException {
        this(parent);
        this.input(s);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s) throws IOException {
        this.reset();
        ASN1GenericConstructed bc = (ASN1GenericConstructed)s.elementAt(1);
        ASN1Sequence epki = (ASN1Sequence)bc.elementAt(0);
        this.pkcs8 = new PKCS8_FIPS(epki);
    }

    public void output(OutputStream os) throws IOException {
        try {
            this.toASN1().output(os);
        }
        catch (StreamableOutputException ex) {
            throw new IOException(ex.toString());
        }
    }

    private ASN1Sequence toASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence p8cont = null;
        try {
            p8cont = (ASN1Sequence)this.pkcs8.getContents();
        }
        catch (StreamableOutputException ex) {
            this.pkcs8.setPassword(this.getPassword());
            p8cont = (ASN1Sequence)this.pkcs8.getContents();
        }
        ASN1Sequence s = new ASN1Sequence();
        s.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2));
        s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)p8cont, 0));
        ASN1Set attr = this.outputAttrsASN1();
        if (attr != null) {
            s.addElement((ASN1Object)attr);
        }
        this.contents = s;
        return s;
    }

    public int length() {
        return this.toASN1().length();
    }

    public void setPassword(String passwd) {
        this.passwd = passwd == null ? null : passwd.toCharArray();
        this.reset();
    }

    public void setPasswd(char[] passwd) {
        this.passwd = passwd;
        this.reset();
    }

    public String getPassword() {
        return this.passwd != null ? new String(this.passwd) : this.parent.getPassword();
    }

    public char[] getPasswd() {
        return this.passwd != null ? this.passwd : this.parent.getPasswd();
    }

    public PrivateKey getPrivateKey() {
        if (this.pkcs8 == null) {
            return null;
        }
        this.pkcs8.setPassword(this.getPassword());
        return this.getPKCS8_FIPS().getKey();
    }

    public PrivateKeyPKCS8 getPKCS8() {
        return this.getPKCS8_FIPS();
    }

    public void setPKCS8(PrivateKeyPKCS8 pkcs8) {
        this.setPKCS8_FIPS(pkcs8);
        this.reset();
    }

    private void setPKCS8_FIPS(PrivateKeyPKCS8 pkcs8) {
        block7: {
            if (!(pkcs8 instanceof PKCS8_FIPS)) {
                try {
                    pkcs8 = new PKCS8_FIPS((InputStream)new UnsyncByteArrayInputStream(pkcs8.getEncoded()));
                }
                catch (IOException ex) {
                    throw new StreamableInputException(ex.toString());
                }
                catch (StreamableOutputException ex) {
                    String pwd = this.getPassword();
                    if (pwd == null) break block7;
                    pkcs8.setPassword(pwd);
                    try {
                        pkcs8 = new PKCS8_FIPS((InputStream)new UnsyncByteArrayInputStream(pkcs8.getEncoded()));
                    }
                    catch (IOException ex2) {
                        throw new StreamableInputException(ex.toString());
                    }
                    catch (StreamableOutputException streamableOutputException) {
                        // empty catch block
                    }
                }
            }
        }
        this.pkcs8 = pkcs8;
    }

    private PrivateKeyPKCS8 getPKCS8_FIPS() {
        block7: {
            if (!(this.pkcs8 instanceof PKCS8_FIPS)) {
                try {
                    this.pkcs8 = new PKCS8_FIPS((InputStream)new UnsyncByteArrayInputStream(this.pkcs8.getEncoded()));
                }
                catch (IOException ex) {
                    throw new StreamableInputException(ex.toString());
                }
                catch (StreamableOutputException ex) {
                    String pwd = this.getPassword();
                    if (pwd == null) break block7;
                    this.pkcs8.setPassword(pwd);
                    try {
                        this.pkcs8 = new PKCS8_FIPS((InputStream)new UnsyncByteArrayInputStream(this.pkcs8.getEncoded()));
                    }
                    catch (IOException ex2) {
                        throw new StreamableInputException(ex.toString());
                    }
                    catch (StreamableOutputException streamableOutputException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.pkcs8;
    }

    public String toString() {
        String s = "";
        if (this.friendlyName != null) {
            s = s + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            s = s + "localKeyID = " + Utils.toHexString((byte[])this.localKeyID) + ", ";
        }
        return s + this.pkcs8.toString();
    }

    private static class PKCS8_FIPS
    extends PrivateKeyPKCS8 {
        public PKCS8_FIPS(InputStream is) throws IOException {
            super(is);
        }

        public PKCS8_FIPS(ASN1Sequence s) throws IOException {
            super(Utils.toStream((Streamable)s));
        }

        protected void assertAllowExport() {
        }
    }
}

