/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.Date;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.HIGH_AVAILABILITY})
public class OracleFailoverEventImpl
implements OracleFailoverEvent {
    private String m_serviceName = null;
    private String m_instanceName = null;
    private String m_dbUniqueName = null;
    private String m_hostName = null;
    private String m_dbDomainName = null;
    private String m_status = null;
    private int m_cardinality = 0;
    private String m_reason = null;
    private String m_eventType;
    private Date m_timestamp = null;
    private String m_timezone = null;
    private boolean m_isValid = true;
    private int m_drainTimeout = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    public OracleFailoverEventImpl(String eventType) throws UniversalConnectionPoolException {
        this.setEventType(eventType);
    }

    private void validateEventType(String eventType) throws UniversalConnectionPoolException {
        if (eventType == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(304);
        }
        if (!eventType.equals("database/event/host") && !eventType.equals("database/event/service")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(305);
        }
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.m_instanceName = instanceName;
    }

    @Override
    public String getDbUniqueName() {
        return this.m_dbUniqueName;
    }

    public void setDbUniqueName(String dbUniqueName) {
        this.m_dbUniqueName = dbUniqueName;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    @Override
    public String getDbDomainName() {
        return this.m_dbDomainName;
    }

    public void setDbDomainName(String domainName) {
        this.m_dbDomainName = domainName;
    }

    @Override
    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    @Override
    public int getCardinality() {
        return this.m_cardinality;
    }

    public void setCardinality(int cardinality) {
        this.m_cardinality = cardinality;
    }

    @Override
    public String getReason() {
        return this.m_reason;
    }

    public void setReason(String reason) {
        this.m_reason = reason;
    }

    @Override
    public String getEventType() {
        return this.m_eventType;
    }

    public void setEventType(String eventType) throws UniversalConnectionPoolException {
        this.validateEventType(eventType);
        this.m_eventType = eventType;
    }

    @Override
    public long getTimestamp() {
        return this.m_timestamp != null ? this.m_timestamp.getTime() : -1L;
    }

    public void setTimestamp(Date ts) {
        this.m_timestamp = ts;
    }

    @Override
    public String getTimeZone() {
        return this.m_timezone;
    }

    public void setTimeZone(String timezone) {
        this.m_timezone = timezone;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    public void setValidity(boolean isValid) {
        this.m_isValid = isValid;
    }

    @Override
    public int getDrainTimeout() {
        return this.m_drainTimeout;
    }

    void setDrainTimeout(int drainTimeout) {
        this.m_drainTimeout = drainTimeout;
    }

    @DisableTrace
    public String toString() {
        return "Service name: " + this.m_serviceName + ", Instance name: " + this.m_instanceName + ", Unique name: " + this.m_dbUniqueName + ", Host name: " + this.m_hostName + ", Domain name: " + this.m_dbDomainName + ", Status: " + this.m_status + ", Cardinality: " + this.m_cardinality + ", Reason: " + this.m_reason + ", Drain timeout: " + this.m_drainTimeout + ", Event type: " + this.m_eventType + ", Timestamp: " + this.m_timestamp + ", Is Valid: " + this.m_isValid;
    }

    static {
        try {
            $$$methodRef$$$27 = OracleFailoverEventImpl.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$26 = OracleFailoverEventImpl.class.getDeclaredMethod("setDrainTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$25 = OracleFailoverEventImpl.class.getDeclaredMethod("getDrainTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$24 = OracleFailoverEventImpl.class.getDeclaredMethod("setValidity", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$23 = OracleFailoverEventImpl.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$22 = OracleFailoverEventImpl.class.getDeclaredMethod("setTimeZone", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$21 = OracleFailoverEventImpl.class.getDeclaredMethod("getTimeZone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$20 = OracleFailoverEventImpl.class.getDeclaredMethod("setTimestamp", Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$19 = OracleFailoverEventImpl.class.getDeclaredMethod("getTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$18 = OracleFailoverEventImpl.class.getDeclaredMethod("setEventType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$17 = OracleFailoverEventImpl.class.getDeclaredMethod("getEventType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$16 = OracleFailoverEventImpl.class.getDeclaredMethod("setReason", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$15 = OracleFailoverEventImpl.class.getDeclaredMethod("getReason", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$14 = OracleFailoverEventImpl.class.getDeclaredMethod("setCardinality", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$13 = OracleFailoverEventImpl.class.getDeclaredMethod("getCardinality", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$12 = OracleFailoverEventImpl.class.getDeclaredMethod("setStatus", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$11 = OracleFailoverEventImpl.class.getDeclaredMethod("getStatus", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$10 = OracleFailoverEventImpl.class.getDeclaredMethod("setDbDomainName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$9 = OracleFailoverEventImpl.class.getDeclaredMethod("getDbDomainName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$8 = OracleFailoverEventImpl.class.getDeclaredMethod("setHostName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$7 = OracleFailoverEventImpl.class.getDeclaredMethod("getHostName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = OracleFailoverEventImpl.class.getDeclaredMethod("setDbUniqueName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = OracleFailoverEventImpl.class.getDeclaredMethod("getDbUniqueName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = OracleFailoverEventImpl.class.getDeclaredMethod("setInstanceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = OracleFailoverEventImpl.class.getDeclaredMethod("getInstanceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = OracleFailoverEventImpl.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleFailoverEventImpl.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleFailoverEventImpl.class.getDeclaredMethod("validateEventType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

