/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;

abstract class Redirector<T> {
    private final Class<T> type;
    private static final HashMap<Class<?>, Redirector<?>> CLASS_TO_REDIRECTOR = new HashMap();
    private static final HashMap<Class<?>, Redirector<?>> CLASS_TO_ERROR;

    private Redirector(Class<T> _type) {
        this.type = _type;
    }

    abstract T redirect(Accessor var1, int var2) throws SQLException;

    final Class<T> getTarget() {
        return this.type;
    }

    public String toString() {
        return super.toString() + "[" + this.type.getName() + "]";
    }

    static <V> Redirector<V> createObjectRedirector(Class<V> target) {
        return new Redirector<V>((Class)target){

            @Override
            final V redirect(Accessor acc, int currentRow) throws SQLException {
                try {
                    Object obj = acc.getObject(currentRow);
                    Class targetType = this.getTarget();
                    if (obj != null && !targetType.isInstance(obj)) {
                        throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)1.getConnectionDuringExceptionHandling(), 49, targetType.getName()).fillInStackTrace();
                    }
                    return obj;
                }
                catch (ClassCastException ex) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)1.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            }
        };
    }

    static <V> Redirector<V> createValueOfRedirector(Class<V> target, List<Class<?>> supportedTypes) {
        if (Modifier.isPublic(target.getModifiers())) {
            Method[] methods = target.getDeclaredMethods();
            int desireable = Integer.MAX_VALUE;
            Method method = null;
            Class<?> type = null;
            for (Method m : methods) {
                if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getName().equals("valueOf") && m.getParameterTypes().length == 1 && target.isAssignableFrom(m.getReturnType())) {
                    int i = 0;
                    for (Class<?> t : supportedTypes) {
                        if (m.getParameterTypes()[0].isAssignableFrom(t)) {
                            if (i >= desireable) break;
                            desireable = i;
                            method = m;
                            type = t;
                            break;
                        }
                        ++i;
                    }
                }
                if (desireable == 0) break;
            }
            if (method != null) {
                return Redirector.createValueOfRedirector(target, method, type);
            }
        }
        return new Redirector<V>((Class)target){

            @Override
            final V redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)2.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        };
    }

    private static <V, W> Redirector<V> createValueOfRedirector(Class<V> target, final Method staticValueOf, Class<W> supportedType) {
        final Redirector<?> supportedRedirector = CLASS_TO_REDIRECTOR.get(supportedType);
        return new Redirector<V>(target){

            @Override
            final V redirect(Accessor acc, int currentRow) throws SQLException {
                try {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return staticValueOf.invoke(null, supportedRedirector.redirect(acc, currentRow));
                }
                catch (IllegalAccessException ex) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)3.getConnectionDuringExceptionHandling(), 1, ex.getMessage()).fillInStackTrace();
                }
                catch (IllegalArgumentException ex) {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)3.getConnectionDuringExceptionHandling(), 1, ex.getMessage()).fillInStackTrace();
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof SQLException) {
                        throw (SQLException)ex.getTargetException();
                    }
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)3.getConnectionDuringExceptionHandling(), 1, "Got something other than a SQLException: " + ex.getTargetException()).fillInStackTrace();
                }
            }
        };
    }

    static Map<Class<?>, Redirector<?>> createRedirectorMap(Collection<Class<?>> supportedTypes) {
        Map m = (Map)CLASS_TO_ERROR.clone();
        for (Class<?> t : supportedTypes) {
            assert (CLASS_TO_REDIRECTOR.get(t) != null) : t;
            m.put(t, CLASS_TO_REDIRECTOR.get(t));
        }
        return m;
    }

    static OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        CLASS_TO_REDIRECTOR.put(Array.class, new Redirector<Array>(Array.class){

            @Override
            final Array redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getARRAY(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(BigDecimal.class, new Redirector<BigDecimal>(BigDecimal.class){

            @Override
            final BigDecimal redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBigDecimal(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Blob.class, new Redirector<Blob>(Blob.class){

            @Override
            final Blob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Boolean.class, new Redirector<Boolean>(Boolean.class){

            @Override
            final Boolean redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBoolean(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Byte.class, new Redirector<Byte>(Byte.class){

            @Override
            final Byte redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getByte(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(byte[].class, new Redirector<byte[]>(byte[].class){

            @Override
            final byte[] redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBytes(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Clob.class, new Redirector<Clob>(Clob.class){

            @Override
            final Clob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(java.sql.Date.class, new Redirector<java.sql.Date>(java.sql.Date.class){

            @Override
            final java.sql.Date redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDate(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Double.class, new Redirector<Double>(Double.class){

            @Override
            final Double redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDouble(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Float.class, new Redirector<Float>(Float.class){

            @Override
            final Float redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return Float.valueOf(acc.getFloat(currentRow));
            }
        });
        CLASS_TO_REDIRECTOR.put(Integer.class, new Redirector<Integer>(Integer.class){

            @Override
            final Integer redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getInt(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Long.class, new Redirector<Long>(Long.class){

            @Override
            final Long redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLong(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(NClob.class, new Redirector<NClob>(NClob.class){

            @Override
            final NClob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNClob(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Ref.class, new Redirector<Ref>(Ref.class){

            @Override
            final Ref redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getREF(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(RowId.class, new Redirector<RowId>(RowId.class){

            @Override
            final RowId redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getROWID(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Short.class, new Redirector<Short>(Short.class){

            @Override
            final Short redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getShort(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(SQLXML.class, new Redirector<SQLXML>(SQLXML.class){

            @Override
            final SQLXML redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getSQLXML(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(String.class, new Redirector<String>(String.class){

            @Override
            final String redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getString(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Struct.class, new Redirector<Struct>(Struct.class){

            @Override
            final Struct redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getStruct(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Time.class, new Redirector<Time>(Time.class){

            @Override
            final Time redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTime(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Timestamp.class, new Redirector<Timestamp>(Timestamp.class){

            @Override
            final Timestamp redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTimestamp(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(URL.class, new Redirector<URL>(URL.class){

            @Override
            final URL redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getURL(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(BigInteger.class, new Redirector<BigInteger>(BigInteger.class){

            @Override
            final BigInteger redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBigInteger(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Date.class, new Redirector<Date>(Date.class){

            @Override
            final Date redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getJavaUtilDate(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Calendar.class, new Redirector<Calendar>(Calendar.class){

            @Override
            final Calendar redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCalendar(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Duration.class, new Redirector<Duration>(Duration.class){

            @Override
            final Duration redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDuration(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(LocalDate.class, new Redirector<LocalDate>(LocalDate.class){

            @Override
            final LocalDate redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLocalDate(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(LocalDateTime.class, new Redirector<LocalDateTime>(LocalDateTime.class){

            @Override
            final LocalDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLocalDateTime(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(LocalTime.class, new Redirector<LocalTime>(LocalTime.class){

            @Override
            final LocalTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getLocalTime(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OffsetDateTime.class, new Redirector<OffsetDateTime>(OffsetDateTime.class){

            @Override
            final OffsetDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOffsetDateTime(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OffsetTime.class, new Redirector<OffsetTime>(OffsetTime.class){

            @Override
            final OffsetTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOffsetTime(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Period.class, new Redirector<Period>(Period.class){

            @Override
            final Period redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getPeriod(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(ZonedDateTime.class, new Redirector<ZonedDateTime>(ZonedDateTime.class){

            @Override
            final ZonedDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getZonedDateTime(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(ARRAY.class, new Redirector<ARRAY>(ARRAY.class){

            @Override
            final ARRAY redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getARRAY(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(BFILE.class, new Redirector<BFILE>(BFILE.class){

            @Override
            final BFILE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBFILE(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(BINARY_FLOAT.class, new Redirector<BINARY_FLOAT>(BINARY_FLOAT.class){

            @Override
            final BINARY_FLOAT redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBINARY_FLOAT(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(BINARY_DOUBLE.class, new Redirector<BINARY_DOUBLE>(BINARY_DOUBLE.class){

            @Override
            final BINARY_DOUBLE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBINARY_DOUBLE(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(BLOB.class, new Redirector<BLOB>(BLOB.class){

            @Override
            final BLOB redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(CHAR.class, new Redirector<CHAR>(CHAR.class){

            @Override
            final CHAR redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCHAR(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(CLOB.class, new Redirector<CLOB>(CLOB.class){

            @Override
            final CLOB redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(ResultSet.class, new Redirector<ResultSet>(ResultSet.class){

            @Override
            final ResultSet redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCursor(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(DATE.class, new Redirector<DATE>(DATE.class){

            @Override
            final DATE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDATE(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(INTERVALDS.class, new Redirector<INTERVALDS>(INTERVALDS.class){

            @Override
            final INTERVALDS redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getINTERVALDS(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(INTERVALYM.class, new Redirector<INTERVALYM>(INTERVALYM.class){

            @Override
            final INTERVALYM redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getINTERVALYM(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(NCLOB.class, new Redirector<NCLOB>(NCLOB.class){

            @Override
            final NCLOB redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNCLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(NUMBER.class, new Redirector<NUMBER>(NUMBER.class){

            @Override
            final NUMBER redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNUMBER(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OPAQUE.class, new Redirector<OPAQUE>(OPAQUE.class){

            @Override
            final OPAQUE redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOPAQUE(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(ORAData.class, new Redirector<ORAData>(ORAData.class){

            @Override
            final ORAData redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getORAData(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleData.class, new Redirector<OracleData>(OracleData.class){

            @Override
            final OracleData redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleData(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(RAW.class, new Redirector<RAW>(RAW.class){

            @Override
            final RAW redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getRAW(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(REF.class, new Redirector<REF>(REF.class){

            @Override
            final REF redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getREF(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(ROWID.class, new Redirector<ROWID>(ROWID.class){

            @Override
            final ROWID redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getROWID(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(STRUCT.class, new Redirector<STRUCT>(STRUCT.class){

            @Override
            final STRUCT redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getSTRUCT(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMPLTZ.class, new Redirector<TIMESTAMPLTZ>(TIMESTAMPLTZ.class){

            @Override
            final TIMESTAMPLTZ redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTIMESTAMPLTZ(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMPTZ.class, new Redirector<TIMESTAMPTZ>(TIMESTAMPTZ.class){

            @Override
            final TIMESTAMPTZ redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTIMESTAMPTZ(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(TIMESTAMP.class, new Redirector<TIMESTAMP>(TIMESTAMP.class){

            @Override
            final TIMESTAMP redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getTIMESTAMP(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleArray.class, new Redirector<OracleArray>(OracleArray.class){

            @Override
            final OracleArray redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getARRAY(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleBfile.class, new Redirector<OracleBfile>(OracleBfile.class){

            @Override
            final OracleBfile redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBFILE(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleBlob.class, new Redirector<OracleBlob>(OracleBlob.class){

            @Override
            final OracleBlob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleClob.class, new Redirector<OracleClob>(OracleClob.class){

            @Override
            final OracleClob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleNClob.class, new Redirector<OracleNClob>(OracleNClob.class){

            @Override
            final OracleNClob redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getNCLOB(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleOpaque.class, new Redirector<OracleOpaque>(OracleOpaque.class){

            @Override
            final OracleOpaque redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOPAQUE(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleRef.class, new Redirector<OracleRef>(OracleRef.class){

            @Override
            final OracleRef redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getREF(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleStruct.class, new Redirector<OracleStruct>(OracleStruct.class){

            @Override
            final OracleStruct redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getSTRUCT(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(InputStream.class, new Redirector<InputStream>(InputStream.class){

            @Override
            final InputStream redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getBinaryStream(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Reader.class, new Redirector<Reader>(Reader.class){

            @Override
            final Reader redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getCharacterStream(currentRow);
            }
        });
        if (PhysicalConnection.isJsonJarPresent()) {
            CLASS_TO_REDIRECTOR.put(JsonValue.class, new Redirector<JsonValue>(JsonValue.class){

                @Override
                final JsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonValue(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(javax.json.stream.JsonParser.class, new Redirector<javax.json.stream.JsonParser>(javax.json.stream.JsonParser.class){

                @Override
                final javax.json.stream.JsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonParser(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonStructure.class, new Redirector<JsonStructure>(JsonStructure.class){

                @Override
                final JsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonStructure(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(javax.json.JsonObject.class, new Redirector<javax.json.JsonObject>(javax.json.JsonObject.class){

                @Override
                final javax.json.JsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonObject(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonArray.class, new Redirector<JsonArray>(JsonArray.class){

                @Override
                final JsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonArray(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonString.class, new Redirector<JsonString>(JsonString.class){

                @Override
                final JsonString redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonString(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(javax.json.JsonNumber.class, new Redirector<javax.json.JsonNumber>(javax.json.JsonNumber.class){

                @Override
                final javax.json.JsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJsonNumber(currentRow);
                }
            });
        }
        if (PhysicalConnection.isJakartaJarPresent()) {
            CLASS_TO_REDIRECTOR.put(jakarta.json.JsonValue.class, new Redirector<jakarta.json.JsonValue>(jakarta.json.JsonValue.class){

                @Override
                final jakarta.json.JsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJakartaJsonValue(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonParser.class, new Redirector<JsonParser>(JsonParser.class){

                @Override
                final JsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJakartaJsonParser(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(jakarta.json.JsonStructure.class, new Redirector<jakarta.json.JsonStructure>(jakarta.json.JsonStructure.class){

                @Override
                final jakarta.json.JsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJakartaJsonStructure(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonObject.class, new Redirector<JsonObject>(JsonObject.class){

                @Override
                final JsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJakartaJsonObject(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(jakarta.json.JsonArray.class, new Redirector<jakarta.json.JsonArray>(jakarta.json.JsonArray.class){

                @Override
                final jakarta.json.JsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJakartaJsonArray(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(jakarta.json.JsonString.class, new Redirector<jakarta.json.JsonString>(jakarta.json.JsonString.class){

                @Override
                final jakarta.json.JsonString redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJakartaJsonString(currentRow);
                }
            });
            CLASS_TO_REDIRECTOR.put(JsonNumber.class, new Redirector<JsonNumber>(JsonNumber.class){

                @Override
                final JsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                    if (acc.isNull(currentRow)) {
                        return null;
                    }
                    return acc.getJakartaJsonNumber(currentRow);
                }
            });
        }
        CLASS_TO_REDIRECTOR.put(OracleJsonValue.class, new Redirector<OracleJsonValue>(OracleJsonValue.class){

            @Override
            final OracleJsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonValue(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonStructure.class, new Redirector<OracleJsonStructure>(OracleJsonStructure.class){

            @Override
            final OracleJsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonStructure(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonObject.class, new Redirector<OracleJsonObject>(OracleJsonObject.class){

            @Override
            final OracleJsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonObject(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonArray.class, new Redirector<OracleJsonArray>(OracleJsonArray.class){

            @Override
            final OracleJsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonArray(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonString.class, new Redirector<OracleJsonString>(OracleJsonString.class){

            @Override
            final OracleJsonString redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonString(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonNumber.class, new Redirector<OracleJsonNumber>(OracleJsonNumber.class){

            @Override
            final OracleJsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonNumber(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDecimal.class, new Redirector<OracleJsonDecimal>(OracleJsonDecimal.class){

            @Override
            final OracleJsonDecimal redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDecimal(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonFloat.class, new Redirector<OracleJsonFloat>(OracleJsonFloat.class){

            @Override
            final OracleJsonFloat redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonFloat(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDouble.class, new Redirector<OracleJsonDouble>(OracleJsonDouble.class){

            @Override
            final OracleJsonDouble redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDouble(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonTimestamp.class, new Redirector<OracleJsonTimestamp>(OracleJsonTimestamp.class){

            @Override
            final OracleJsonTimestamp redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonTimestamp(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDate.class, new Redirector<OracleJsonDate>(OracleJsonDate.class){

            @Override
            final OracleJsonDate redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDate(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonBinary.class, new Redirector<OracleJsonBinary>(OracleJsonBinary.class){

            @Override
            final OracleJsonBinary redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonBinary(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonIntervalDS.class, new Redirector<OracleJsonIntervalDS>(OracleJsonIntervalDS.class){

            @Override
            final OracleJsonIntervalDS redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonIntervalDS(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonIntervalYM.class, new Redirector<OracleJsonIntervalYM>(OracleJsonIntervalYM.class){

            @Override
            final OracleJsonIntervalYM redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonIntervalYM(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonDatum.class, new Redirector<OracleJsonDatum>(OracleJsonDatum.class){

            @Override
            final OracleJsonDatum redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonDatum(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(Datum.class, new Redirector<Datum>(Datum.class){

            @Override
            final Datum redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getDatum(currentRow);
            }
        });
        CLASS_TO_REDIRECTOR.put(OracleJsonParser.class, new Redirector<OracleJsonParser>(OracleJsonParser.class){

            @Override
            final OracleJsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                if (acc.isNull(currentRow)) {
                    return null;
                }
                return acc.getOracleJsonParser(currentRow);
            }
        });
        CLASS_TO_ERROR = new HashMap();
        CLASS_TO_ERROR.put(Array.class, new Redirector<Array>(Array.class){

            @Override
            final Array redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)101.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(BigDecimal.class, new Redirector<BigDecimal>(BigDecimal.class){

            @Override
            final BigDecimal redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)102.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Blob.class, new Redirector<Blob>(Blob.class){

            @Override
            final Blob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)103.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Boolean.class, new Redirector<Boolean>(Boolean.class){

            @Override
            final Boolean redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)104.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Byte.class, new Redirector<Byte>(Byte.class){

            @Override
            final Byte redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)105.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(byte[].class, new Redirector<byte[]>(byte[].class){

            @Override
            final byte[] redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)106.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Clob.class, new Redirector<Clob>(Clob.class){

            @Override
            final Clob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)107.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(java.sql.Date.class, new Redirector<java.sql.Date>(java.sql.Date.class){

            @Override
            final java.sql.Date redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)108.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Double.class, new Redirector<Double>(Double.class){

            @Override
            final Double redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)109.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Float.class, new Redirector<Float>(Float.class){

            @Override
            final Float redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)110.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Integer.class, new Redirector<Integer>(Integer.class){

            @Override
            final Integer redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)111.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Long.class, new Redirector<Long>(Long.class){

            @Override
            final Long redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)112.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(NClob.class, new Redirector<NClob>(NClob.class){

            @Override
            final NClob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)113.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Ref.class, new Redirector<Ref>(Ref.class){

            @Override
            final Ref redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)114.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(RowId.class, new Redirector<RowId>(RowId.class){

            @Override
            final RowId redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)115.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Short.class, new Redirector<Short>(Short.class){

            @Override
            final Short redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)116.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(SQLXML.class, new Redirector<SQLXML>(SQLXML.class){

            @Override
            final SQLXML redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)117.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(String.class, new Redirector<String>(String.class){

            @Override
            final String redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)118.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Struct.class, new Redirector<Struct>(Struct.class){

            @Override
            final Struct redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)119.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Time.class, new Redirector<Time>(Time.class){

            @Override
            final Time redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)120.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Timestamp.class, new Redirector<Timestamp>(Timestamp.class){

            @Override
            final Timestamp redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)121.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(URL.class, new Redirector<URL>(URL.class){

            @Override
            final URL redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)122.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(BigInteger.class, new Redirector<BigInteger>(BigInteger.class){

            @Override
            final BigInteger redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)123.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Date.class, new Redirector<Date>(Date.class){

            @Override
            final Date redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)124.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Calendar.class, new Redirector<Calendar>(Calendar.class){

            @Override
            final Calendar redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)125.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Duration.class, new Redirector<Duration>(Duration.class){

            @Override
            final Duration redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)126.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(LocalDate.class, new Redirector<LocalDate>(LocalDate.class){

            @Override
            final LocalDate redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)127.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(LocalDateTime.class, new Redirector<LocalDateTime>(LocalDateTime.class){

            @Override
            final LocalDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)128.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(LocalTime.class, new Redirector<LocalTime>(LocalTime.class){

            @Override
            final LocalTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)129.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OffsetDateTime.class, new Redirector<OffsetDateTime>(OffsetDateTime.class){

            @Override
            final OffsetDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)130.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OffsetTime.class, new Redirector<OffsetTime>(OffsetTime.class){

            @Override
            final OffsetTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)131.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Period.class, new Redirector<Period>(Period.class){

            @Override
            final Period redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)132.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(ZonedDateTime.class, new Redirector<ZonedDateTime>(ZonedDateTime.class){

            @Override
            final ZonedDateTime redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)133.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(ARRAY.class, new Redirector<ARRAY>(ARRAY.class){

            @Override
            final ARRAY redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)134.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(BFILE.class, new Redirector<BFILE>(BFILE.class){

            @Override
            final BFILE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)135.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(BINARY_FLOAT.class, new Redirector<BINARY_FLOAT>(BINARY_FLOAT.class){

            @Override
            final BINARY_FLOAT redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)136.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(BINARY_DOUBLE.class, new Redirector<BINARY_DOUBLE>(BINARY_DOUBLE.class){

            @Override
            final BINARY_DOUBLE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)137.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(BLOB.class, new Redirector<BLOB>(BLOB.class){

            @Override
            final BLOB redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)138.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(CHAR.class, new Redirector<CHAR>(CHAR.class){

            @Override
            final CHAR redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)139.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(CLOB.class, new Redirector<CLOB>(CLOB.class){

            @Override
            final CLOB redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)140.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(ResultSet.class, new Redirector<ResultSet>(ResultSet.class){

            @Override
            final ResultSet redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)141.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(DATE.class, new Redirector<DATE>(DATE.class){

            @Override
            final DATE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)142.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(INTERVALDS.class, new Redirector<INTERVALDS>(INTERVALDS.class){

            @Override
            final INTERVALDS redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)143.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(INTERVALYM.class, new Redirector<INTERVALYM>(INTERVALYM.class){

            @Override
            final INTERVALYM redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)144.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(NCLOB.class, new Redirector<NCLOB>(NCLOB.class){

            @Override
            final NCLOB redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)145.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(NUMBER.class, new Redirector<NUMBER>(NUMBER.class){

            @Override
            final NUMBER redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)146.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OPAQUE.class, new Redirector<OPAQUE>(OPAQUE.class){

            @Override
            final OPAQUE redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)147.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(ORAData.class, new Redirector<ORAData>(ORAData.class){

            @Override
            final ORAData redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)148.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleData.class, new Redirector<OracleData>(OracleData.class){

            @Override
            final OracleData redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)149.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(RAW.class, new Redirector<RAW>(RAW.class){

            @Override
            final RAW redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)150.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(REF.class, new Redirector<REF>(REF.class){

            @Override
            final REF redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)151.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(ROWID.class, new Redirector<ROWID>(ROWID.class){

            @Override
            final ROWID redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)152.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(STRUCT.class, new Redirector<STRUCT>(STRUCT.class){

            @Override
            final STRUCT redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)153.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMPLTZ.class, new Redirector<TIMESTAMPLTZ>(TIMESTAMPLTZ.class){

            @Override
            final TIMESTAMPLTZ redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)154.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMPTZ.class, new Redirector<TIMESTAMPTZ>(TIMESTAMPTZ.class){

            @Override
            final TIMESTAMPTZ redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)155.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(TIMESTAMP.class, new Redirector<TIMESTAMP>(TIMESTAMP.class){

            @Override
            final TIMESTAMP redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)156.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleArray.class, new Redirector<OracleArray>(OracleArray.class){

            @Override
            final OracleArray redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)157.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleBfile.class, new Redirector<OracleBfile>(OracleBfile.class){

            @Override
            final OracleBfile redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)158.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleBlob.class, new Redirector<OracleBlob>(OracleBlob.class){

            @Override
            final OracleBlob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)159.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleClob.class, new Redirector<OracleClob>(OracleClob.class){

            @Override
            final OracleClob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)160.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleNClob.class, new Redirector<OracleNClob>(OracleNClob.class){

            @Override
            final OracleNClob redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)161.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleOpaque.class, new Redirector<OracleOpaque>(OracleOpaque.class){

            @Override
            final OracleOpaque redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)162.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleRef.class, new Redirector<OracleRef>(OracleRef.class){

            @Override
            final OracleRef redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)163.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(OracleStruct.class, new Redirector<OracleStruct>(OracleStruct.class){

            @Override
            final OracleStruct redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)164.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(InputStream.class, new Redirector<InputStream>(InputStream.class){

            @Override
            final InputStream redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)165.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        CLASS_TO_ERROR.put(Reader.class, new Redirector<Reader>(Reader.class){

            @Override
            final Reader redirect(Accessor acc, int currentRow) throws SQLException {
                throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)166.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            }
        });
        if (PhysicalConnection.isJsonJarPresent()) {
            CLASS_TO_ERROR.put(JsonValue.class, new Redirector<JsonValue>(JsonValue.class){

                @Override
                final JsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)167.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(javax.json.stream.JsonParser.class, new Redirector<javax.json.stream.JsonParser>(javax.json.stream.JsonParser.class){

                @Override
                final javax.json.stream.JsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)168.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(JsonStructure.class, new Redirector<JsonStructure>(JsonStructure.class){

                @Override
                final JsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)169.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(javax.json.JsonObject.class, new Redirector<javax.json.JsonObject>(javax.json.JsonObject.class){

                @Override
                final javax.json.JsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)170.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(JsonArray.class, new Redirector<JsonArray>(JsonArray.class){

                @Override
                final JsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)171.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(JsonString.class, new Redirector<JsonString>(JsonString.class){

                @Override
                final JsonString redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)172.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(javax.json.JsonNumber.class, new Redirector<javax.json.JsonNumber>(javax.json.JsonNumber.class){

                @Override
                final javax.json.JsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)173.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
        }
        if (PhysicalConnection.isJakartaJarPresent()) {
            CLASS_TO_ERROR.put(jakarta.json.JsonValue.class, new Redirector<jakarta.json.JsonValue>(jakarta.json.JsonValue.class){

                @Override
                final jakarta.json.JsonValue redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)174.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(JsonParser.class, new Redirector<JsonParser>(JsonParser.class){

                @Override
                final JsonParser redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)175.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(jakarta.json.JsonStructure.class, new Redirector<jakarta.json.JsonStructure>(jakarta.json.JsonStructure.class){

                @Override
                final jakarta.json.JsonStructure redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)176.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(JsonObject.class, new Redirector<JsonObject>(JsonObject.class){

                @Override
                final JsonObject redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)177.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(jakarta.json.JsonArray.class, new Redirector<jakarta.json.JsonArray>(jakarta.json.JsonArray.class){

                @Override
                final jakarta.json.JsonArray redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)178.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(jakarta.json.JsonString.class, new Redirector<jakarta.json.JsonString>(jakarta.json.JsonString.class){

                @Override
                final jakarta.json.JsonString redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)179.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
            CLASS_TO_ERROR.put(JsonNumber.class, new Redirector<JsonNumber>(JsonNumber.class){

                @Override
                final JsonNumber redirect(Accessor acc, int currentRow) throws SQLException {
                    throw (SQLException)DatabaseError.createSqlException((oracle.jdbc.internal.OracleConnection)180.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            });
        }
    }
}

