/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.AccessTokenCache;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.OpaqueAccessToken;
import oracle.jdbc.driver.OpaquePrivateKey;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public final class JsonWebToken
extends OpaqueAccessToken {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("E, dd MMM uuuu HH:mm:ss z", Locale.US);
    private static final int CACHES_SIZE = 128;
    private static final Map<Builder, AccessTokenCache<JsonWebToken>> CACHES = Collections.synchronizedMap(new LinkedHashMap<Builder, AccessTokenCache<JsonWebToken>>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Builder, AccessTokenCache<JsonWebToken>> entry) {
            return this.size() > 128;
        }
    });

    private JsonWebToken(@Blind OpaqueString token, OffsetDateTime expiration, @Blind OpaquePrivateKey opaquePrivateKey) {
        super(token, expiration, opaquePrivateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromOciFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        char[] tokenChars = JsonWebToken.readTokenFile(path.resolve("token"));
        try {
            OffsetDateTime expiration = JsonWebToken.parseExp(tokenChars);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(tokenChars), expiration, OpaquePrivateKey.fromPemFile(path.resolve("oci_db_key.pem")));
            return jsonWebToken;
        }
        finally {
            Arrays.fill(tokenChars, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromFile(Path path) throws IOException {
        char[] tokenChars = Files.isDirectory(path, new LinkOption[0]) ? JsonWebToken.readTokenFile(path.resolve("token")) : JsonWebToken.readTokenFile(path);
        try {
            OffsetDateTime expiration = JsonWebToken.parseExp(tokenChars);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(tokenChars), expiration, null);
            return jsonWebToken;
        }
        finally {
            Arrays.fill(tokenChars, '\u0000');
        }
    }

    static Builder requestBuilder() {
        return new Builder();
    }

    @Blind
    public static JsonWebToken createProofOfPossessionToken(@Blind char[] token, @Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(OpaqueString.newOpaqueString((char[])token.clone()), JsonWebToken.parseExp(token), OpaquePrivateKey.fromPrivateKey(privateKey));
    }

    @Blind
    public static JsonWebToken createBearerToken(@Blind char[] token) {
        return new JsonWebToken(OpaqueString.newOpaqueString((char[])token.clone()), JsonWebToken.parseExp(token), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static char[] readTokenFile(Path path) throws IOException {
        JsonWebToken.requireValidSize(Files.size(path));
        byte[] tokenBytes = Files.readAllBytes(path);
        try {
            char[] cArray;
            CharBuffer tokenBuffer = JsonWebToken.detectCharacterSet(tokenBytes).decode(ByteBuffer.wrap(tokenBytes));
            try {
                char[] tokenChars = new char[tokenBuffer.remaining()];
                tokenBuffer.get(tokenChars);
                cArray = tokenChars;
                tokenBuffer.clear();
            }
            catch (Throwable throwable) {
                tokenBuffer.clear();
                tokenBuffer.put(new char[tokenBuffer.remaining()]);
                throw throwable;
            }
            tokenBuffer.put(new char[tokenBuffer.remaining()]);
            return cArray;
        }
        finally {
            Arrays.fill(tokenBytes, (byte)0);
        }
    }

    private static Charset detectCharacterSet(@Blind byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return StandardCharsets.UTF_8;
        }
        if (bytes.length % 2 != 0) {
            return StandardCharsets.UTF_8;
        }
        if (bytes[0] == -2 && bytes[1] == -1) {
            return StandardCharsets.UTF_16BE;
        }
        if (bytes[0] == -1 && bytes[1] == -2) {
            return StandardCharsets.UTF_16LE;
        }
        for (i = 0; i < bytes.length && bytes[i] == 0; i += 2) {
            if (i != bytes.length - 2) continue;
            return StandardCharsets.UTF_16BE;
        }
        for (i = 0; i < bytes.length && bytes[i + 1] == 0; i += 2) {
            if (i != bytes.length - 2) continue;
            return StandardCharsets.UTF_16LE;
        }
        return StandardCharsets.UTF_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OffsetDateTime parseExp(@Blind char[] jwt) {
        OracleJsonValue exp;
        int end;
        int start;
        JsonWebToken.requireValidSize(jwt.length);
        for (start = 0; start < jwt.length && jwt[start] != '.'; ++start) {
        }
        if (++start > jwt.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        for (end = start; end < jwt.length && jwt[end] != '.'; ++end) {
        }
        if (end == jwt.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        byte[] base64Payload = new byte[end - start];
        try {
            for (int i = 0; i < base64Payload.length; ++i) {
                base64Payload[i] = (byte)jwt[i + start];
            }
            byte[] jsonPayload = Base64.getMimeDecoder().decode(base64Payload);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonPayload);){
                exp = (OracleJsonValue)JSON_FACTORY.createJsonTextValue(inputStream).asJsonObject().get("exp");
            }
            catch (ClassCastException | OracleJsonException exception) {
                throw new IllegalArgumentException("JWT payload is not JSON", exception);
            }
            catch (IOException ioException) {
                throw new IllegalArgumentException("Failed to read JWT payload", ioException);
            }
            finally {
                Arrays.fill(jsonPayload, (byte)0);
            }
        }
        finally {
            Arrays.fill(base64Payload, (byte)0);
        }
        if (exp == null) {
            throw new IllegalArgumentException("JWT is missing an exp claim");
        }
        if (!(exp instanceof OracleJsonNumber)) {
            throw new IllegalArgumentException("JWT has an exp claim with a non-numeric value of type: " + (Object)((Object)exp.getOracleJsonType()));
        }
        return Instant.ofEpochSecond(exp.asJsonNumber().longValue()).atOffset(ZoneOffset.UTC);
    }

    private static void requireValidSize(long size) {
        if (size > 16000L) {
            throw new IllegalArgumentException("JWT of size " + size + " bytes exceeds the maximum accepted length of 16kb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static JsonWebToken requestBearerToken(Builder builder) throws IOException {
        URL url = new URL(builder.endPoint);
        if (!"https".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of endpoint is not https: " + url.getProtocol());
        }
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setSSLSocketFactory(CustomSSLSocketFactory.getSSLSocketFactory(builder.tlsConfig, new DMSFactory().new DMSFactory.DMSNoun()));
        connection.setRequestProperty("Date", ZonedDateTime.now(ZoneId.of("Z")).format(DATE_FORMATTER));
        connection.setRequestProperty("Authorization", JsonWebToken.createAuthorization(builder.user, builder.password));
        connection.setDoOutput(true);
        try (OutputStream request = connection.getOutputStream();){
            request.write(String.format("{\"scope\": \"urn:oracle:db::id::%s\", \"tenantId\": \"%s\"}", builder.compartment == null ? "*" : (builder.database == null ? builder.compartment : builder.compartment + "::" + builder.database), builder.tenancy).getBytes(StandardCharsets.UTF_8));
            request.flush();
        }
        var4_4 = null;
        try (InputStream response = connection.getInputStream();){
            JsonWebToken jsonWebToken;
            String token = JSON_FACTORY.createJsonTextValue(response).asJsonObject().getString("token");
            if (token == null) {
                throw new IOException("JSON response does not contain a token");
            }
            char[] tokenChars = token.toCharArray();
            try {
                jsonWebToken = JsonWebToken.createBearerToken(tokenChars);
            }
            catch (Throwable throwable) {
                try {
                    Arrays.fill(tokenChars, '\u0000');
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    var4_4 = throwable2;
                    throw throwable2;
                }
            }
            Arrays.fill(tokenChars, '\u0000');
            return jsonWebToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static String createAuthorization(String user, @Blind OpaqueString password) {
        byte[] userColonBytes = (user + ":").getBytes(StandardCharsets.UTF_8);
        ByteBuffer passwordBuffer = password.map(chars -> StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars)));
        try {
            String string;
            byte[] userColonPassword = new byte[userColonBytes.length + passwordBuffer.remaining()];
            try {
                System.arraycopy(userColonBytes, 0, userColonPassword, 0, userColonBytes.length);
                passwordBuffer.get(userColonPassword, userColonBytes.length, passwordBuffer.remaining());
                string = "Basic " + Base64.getEncoder().encodeToString(userColonPassword);
            }
            catch (Throwable throwable) {
                Arrays.fill(userColonPassword, (byte)0);
                throw throwable;
            }
            Arrays.fill(userColonPassword, (byte)0);
            return string;
        }
        finally {
            passwordBuffer.clear();
            passwordBuffer.put(new byte[passwordBuffer.remaining()]);
        }
    }

    public static AccessTokenCache<JsonWebToken> createCache(Supplier<? extends AccessToken> tokenSupplier) {
        return AccessTokenCache.create(() -> {
            AccessToken accessToken = (AccessToken)tokenSupplier.get();
            if (!(accessToken instanceof JsonWebToken)) {
                throw new IllegalArgumentException("token supplier has output an unrecognized object type: " + accessToken.getClass());
            }
            return (JsonWebToken)accessToken;
        });
    }

    static final class Builder {
        private String endPoint;
        private String tenancy;
        private String compartment;
        private String database;
        private String user;
        private OpaqueString password;
        private Properties tlsConfig;

        private Builder() {
        }

        Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        Builder compartment(String compartment) {
            this.compartment = compartment;
            return this;
        }

        Builder database(String database) {
            this.database = database;
            return this;
        }

        Builder user(String user) {
            this.user = user;
            return this;
        }

        Builder password(@Blind OpaqueString password) {
            this.password = password;
            return this;
        }

        Builder tlsConfig(Properties tlsConfig) {
            this.tlsConfig = (Properties)tlsConfig.clone();
            this.tlsConfig.put((Object)41, "true");
            return this;
        }

        @Blind
        JsonWebToken build() throws IOException {
            try {
                return (JsonWebToken)CACHES.computeIfAbsent(this, this0 -> JsonWebToken.createCache(() -> {
                    try {
                        return JsonWebToken.requestBearerToken(this);
                    }
                    catch (IOException ioException) {
                        throw new UncheckedIOException(ioException);
                    }
                })).get();
            }
            catch (UncheckedIOException ioException) {
                throw ioException.getCause();
            }
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Builder && Objects.equals(this.endPoint, ((Builder)object).endPoint) && Objects.equals(this.tenancy, ((Builder)object).tenancy) && Objects.equals(this.compartment, ((Builder)object).compartment) && Objects.equals(this.database, ((Builder)object).database) && Objects.equals(this.user, ((Builder)object).user) && Objects.equals(this.password, ((Builder)object).password) && Objects.equals(this.tlsConfig, ((Builder)object).tlsConfig);
        }

        public int hashCode() {
            return Objects.hash(this.endPoint, this.tenancy, this.compartment, this.database, this.user, this.password, this.tlsConfig);
        }
    }
}

