/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.internal.XSSessionParameters;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class XSSessionParametersI
extends XSSessionParameters {
    byte[] binaryParam = null;
    String[] textParam = null;
    byte[][] textParamBytes;
    int intParam = 0;

    XSSessionParametersI() {
    }

    void doCharConversion(DBConversion dBConversion) throws SQLException {
        if (this.textParam != null && this.textParam.length > 0) {
            this.textParamBytes = new byte[this.textParam.length][];
            for (int i2 = 0; i2 < this.textParam.length; ++i2) {
                this.textParamBytes[i2] = dBConversion.StringToCharBytes(this.textParam[i2]);
            }
        } else {
            this.textParamBytes = null;
        }
    }

    @Override
    public void setBinary(byte[] byArray) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.binaryParam = (byte[])(byArray == null ? null : Arrays.copyOf(byArray, byArray.length));
    }

    @Override
    public void setInt(int n2) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.intParam = n2;
    }

    @Override
    public void setText(String[] stringArray) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.textParam = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
    }
}

