/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.CompletionStage;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4C7Oversion
extends T4CTTIfun {
    static final long VSN_BANNER_FORMAT_BASE = 0L;
    static final long VSN_BANNER_FORMAT_FULL = 1L;
    byte[] rdbmsVersion = new byte[]{78, 111, 116, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 100, 32, 121, 101, 116};
    private final boolean rdbmsVersionO2U = true;
    private final int bufLen = 256;
    private final boolean retVerLenO2U = true;
    int retVerLen = 0;
    private final boolean retVerNumO2U = true;
    long retVerNum = 0L;

    T4C7Oversion(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)59);
    }

    void doOVERSION() throws SQLException, IOException {
        this.doRPC();
    }

    final CompletionStage<Void> doOVERSIONAsync() {
        return this.doRPCAsync();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.retVerLen = this.meg.unmarshalUB2();
        this.rdbmsVersion = this.meg.unmarshalCHR(this.retVerLen);
        this.retVerNum = this.meg.unmarshalUB4();
    }

    @Override
    void processRPA() throws SQLException {
        if (this.rdbmsVersion == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438).fillInStackTrace();
        }
    }

    byte[] getVersion() {
        return this.rdbmsVersion;
    }

    private static final int serverReleaseRel(long l2) {
        return (int)(l2 >>> 24 & 0xFFL);
    }

    private static final int serverReleaseRelUpd(long l2) {
        int n2 = T4C7Oversion.serverReleaseRel(l2) < 18 ? (int)(l2 >>> 20 & 0xFL) : (int)(l2 >>> 16 & 0xFFL);
        return n2;
    }

    private static final int serverReleaseRelUpdRev(long l2) {
        int n2 = T4C7Oversion.serverReleaseRel(l2) < 18 ? (int)(l2 >>> 12 & 0xFFL) : (int)(l2 >>> 12 & 0xFL);
        return n2;
    }

    private static final int serverReleaseRelUpdInc(long l2) {
        int n2 = T4C7Oversion.serverReleaseRel(l2) < 18 ? (int)(l2 >>> 8 & 0xFL) : (int)(l2 >>> 4 & 0xFFL);
        return n2;
    }

    short getVersionNumber() {
        int n2 = 0;
        if ((n2 += T4C7Oversion.serverReleaseRel(this.retVerNum) * 1000) < 18000) {
            n2 += T4C7Oversion.serverReleaseRelUpd(this.retVerNum) * 100;
        }
        return (short)n2;
    }

    long getVersionNumberasIs() {
        return this.retVerNum;
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalO2U(true);
        this.meg.marshalSWORD(256);
        this.meg.marshalO2U(true);
        this.meg.marshalO2U(true);
        if (this.connection.getTTCVersion() >= 11) {
            this.meg.marshalUB4(1L);
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

