/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.internal;

import java.util.concurrent.TimeUnit;
import org.openqa.selenium.support.ui.Duration;

public enum OperaIntervals {
    RESPONSE_TIMEOUT(new Duration(1L, TimeUnit.MINUTES)),
    IMPLICIT_WAIT(new Duration(0L, TimeUnit.MILLISECONDS)),
    PAGE_LOAD_TIMEOUT(new Duration(30L, TimeUnit.SECONDS)),
    POLL_INTERVAL(new Duration(10L, TimeUnit.MILLISECONDS)),
    WINDOW_EVENT_TIMEOUT(new Duration(5L, TimeUnit.SECONDS)),
    OPERA_IDLE_TIMEOUT(new Duration(5L, TimeUnit.SECONDS)),
    INTERNAL_FREQUENCY(new Duration(0L, TimeUnit.MILLISECONDS)),
    HANDSHAKE_TIMEOUT(new Duration(1L, TimeUnit.MINUTES)),
    KILL_GRACE_TIMEOUT(new Duration(1L, TimeUnit.SECONDS)),
    DEFAULT_RESPONSE_TIMEOUT(new Duration(10L, TimeUnit.SECONDS)),
    QUIT_RESPONSE_TIMEOUT(new Duration(10L, TimeUnit.SECONDS)),
    SCRIPT_TIMEOUT(new Duration(10L, TimeUnit.SECONDS)),
    SCRIPT_RETRY_INTERVAL(new Duration(50L, TimeUnit.MILLISECONDS)),
    LAUNCHER_CONNECT_TIMEOUT(new Duration(5L, TimeUnit.SECONDS)),
    LAUNCHER_RESPONSE_TIMEOUT(new Duration(3L, TimeUnit.MINUTES)),
    PROCESS_START_SLEEP(new Duration(100L, TimeUnit.MILLISECONDS)),
    PROCESS_START_TIMEOUT(new Duration(300L, TimeUnit.MILLISECONDS)),
    MENU_EVENT_TIMEOUT(new Duration(1L, TimeUnit.SECONDS)),
    MULTIPLE_CLICK_SLEEP(new Duration(640L, TimeUnit.MILLISECONDS)),
    WINDOW_CLOSE_TIMEOUT(new Duration(500L, TimeUnit.MILLISECONDS)),
    WINDOW_CLOSE_USING_ACTION_SLEEP(new Duration(10L, TimeUnit.MILLISECONDS)),
    SELFTEST_TIMEOUT(new Duration(200L, TimeUnit.SECONDS)),
    SOCKET_READ_RETRY_TIMEOUT(new Duration(0L, TimeUnit.MILLISECONDS)),
    RUNNER_SCREEN_CAPTURE_TIMEOUT(new Duration(20L, TimeUnit.MILLISECONDS));

    private Duration duration;

    private OperaIntervals(Duration duration) {
        this.duration = duration;
    }

    public void setValue(Duration duration) {
        this.duration = duration;
    }

    public Duration getValue() {
        return this.duration;
    }

    public long getMs() {
        return this.duration.in(TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return this.duration.toString();
    }

    public static String toList() {
        StringBuilder intervals = new StringBuilder();
        for (OperaIntervals item : OperaIntervals.values()) {
            if (intervals.length() != 0) {
                intervals.append(", ");
            }
            intervals.append(item.toString());
        }
        return String.format("Intervals [%s]", intervals.toString());
    }
}

