/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.common.lang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OperaStrings {
    public static boolean isNumeric(String string) {
        return OperaStrings.isDouble(string);
    }

    public static boolean isDouble(String string) {
        if (string == null) {
            return false;
        }
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isInteger(String string) {
        if (string == null) {
            return false;
        }
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String escapeJsString(String string) {
        return OperaStrings.escapeJsString(string, "\"");
    }

    public static String escapeJsString(String string, String quote) {
        Pattern escapePattern = Pattern.compile("([^\\\\])" + quote);
        Matcher m = escapePattern.matcher(" " + string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "$1\\\\" + quote);
        }
        m.appendTail(sb);
        return sb.substring(1);
    }
}

