/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.junit;

import com.google.common.base.Preconditions;
import com.opentable.db.postgres.embedded.DatabasePreparer;
import com.opentable.db.postgres.embedded.PreparedDbProvider;
import javax.sql.DataSource;
import org.junit.rules.ExternalResource;

public class PreparedDbRule
extends ExternalResource {
    private final DatabasePreparer preparer;
    private volatile DataSource dataSource;
    private volatile PreparedDbProvider provider;

    protected PreparedDbRule(DatabasePreparer preparer) {
        Preconditions.checkArgument((preparer != null ? 1 : 0) != 0, (Object)"null preparer");
        this.preparer = preparer;
    }

    protected void before() throws Throwable {
        this.provider = PreparedDbProvider.forPreparer(this.preparer);
        this.dataSource = this.provider.createDataSource();
    }

    protected void after() {
        this.dataSource = null;
        this.provider = null;
    }

    public DataSource getTestDatabase() {
        Preconditions.checkState((this.dataSource != null ? 1 : 0) != 0, (Object)"not initialized");
        return this.dataSource;
    }

    public PreparedDbProvider getDbProvider() {
        Preconditions.checkState((this.provider != null ? 1 : 0) != 0, (Object)"not initialized");
        return this.provider;
    }
}

