/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.DatabasePreparer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;

public class FlywayPreparer
implements DatabasePreparer {
    private final Flyway flyway;
    private final List<String> locations;

    public static FlywayPreparer forClasspathLocation(String ... locations) {
        Flyway f = new Flyway();
        f.setLocations(locations);
        return new FlywayPreparer(f, Arrays.asList(locations));
    }

    private FlywayPreparer(Flyway flyway, List<String> locations) {
        this.flyway = flyway;
        this.locations = locations;
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        this.flyway.setDataSource(ds);
        this.flyway.migrate();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlywayPreparer)) {
            return false;
        }
        return Objects.equals(this.locations, ((FlywayPreparer)obj).locations);
    }

    public int hashCode() {
        return Objects.hashCode(this.locations);
    }
}

