/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.RectPropertySet;
import com.openhtmltopdf.layout.BlockFormattingContext;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.LineBox;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class FloatManager {
    private List<BoxOffset> _leftFloats = Collections.emptyList();
    private List<BoxOffset> _rightFloats = Collections.emptyList();
    private final Box _master;

    public FloatManager(Box master) {
        this._master = master;
    }

    private List<BoxOffset> getAddableFloats(FloatDirection direction) {
        if (this.getFloats(direction).isEmpty()) {
            this.setFloats(direction, new ArrayList<BoxOffset>());
        }
        return this.getFloats(direction);
    }

    private void setFloats(FloatDirection direction, List<BoxOffset> list) {
        if (direction == FloatDirection.LEFT) {
            this._leftFloats = list;
        } else {
            assert (direction == FloatDirection.RIGHT);
            this._rightFloats = list;
        }
    }

    public void floatBox(LayoutContext c, Layer layer, BlockFormattingContext bfc, BlockBox box) {
        if (box.getStyle().isFloatedLeft()) {
            this.position(c, bfc, box, FloatDirection.LEFT);
            this.save(box, layer, bfc, FloatDirection.LEFT);
        } else if (box.getStyle().isFloatedRight()) {
            this.position(c, bfc, box, FloatDirection.RIGHT);
            this.save(box, layer, bfc, FloatDirection.RIGHT);
        }
    }

    public void clear(CssContext cssCtx, BlockFormattingContext bfc, Box box) {
        if (box.getStyle().isClearLeft()) {
            this.moveClear(cssCtx, bfc, box, this.getFloats(FloatDirection.LEFT));
        }
        if (box.getStyle().isClearRight()) {
            this.moveClear(cssCtx, bfc, box, this.getFloats(FloatDirection.RIGHT));
        }
    }

    private void save(BlockBox current, Layer layer, BlockFormattingContext bfc, FloatDirection direction) {
        Point p = bfc.getOffset();
        this.getAddableFloats(direction).add(new BoxOffset(current, p.x, p.y));
        layer.addFloat(current, bfc);
        current.getFloatedBoxData().setManager(this);
        current.calcCanvasLocation();
        current.calcChildLocations();
    }

    private void position(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, FloatDirection direction) {
        this.moveAllTheWayOver(current, direction);
        this.alignToLastOpposingFloat(cssCtx, bfc, current, direction);
        this.alignToLastFloat(cssCtx, bfc, current, direction);
        if (!this.fitsInContainingBlock(current) || this.overlaps(cssCtx, bfc, current, this.getFloats(direction))) {
            this.moveAllTheWayOver(current, direction);
            this.moveFloatBelow(cssCtx, bfc, current, this.getFloats(direction));
        }
        if (this.overlaps(cssCtx, bfc, current, this.getOpposingFloats(direction))) {
            this.moveAllTheWayOver(current, direction);
            this.moveFloatBelow(cssCtx, bfc, current, this.getFloats(direction));
            this.moveFloatBelow(cssCtx, bfc, current, this.getOpposingFloats(direction));
        }
        if (current.getStyle().isCleared()) {
            if (current.getStyle().isClearLeft() && direction == FloatDirection.LEFT) {
                this.moveAllTheWayOver(current, FloatDirection.LEFT);
            } else if (current.getStyle().isClearRight() && direction == FloatDirection.RIGHT) {
                this.moveAllTheWayOver(current, FloatDirection.RIGHT);
            }
            this.moveFloatBelow(cssCtx, bfc, current, this.getFloats(direction));
        }
    }

    public List<BoxOffset> getFloats(FloatDirection direction) {
        return direction == FloatDirection.LEFT ? this._leftFloats : this._rightFloats;
    }

    public Stream<BoxOffset> getFloatStream(FloatDirection direction) {
        return this.getFloats(direction).stream();
    }

    private List<BoxOffset> getOpposingFloats(FloatDirection direction) {
        return direction == FloatDirection.LEFT ? this._rightFloats : this._leftFloats;
    }

    private void alignToLastFloat(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, FloatDirection direction) {
        List<BoxOffset> floats = this.getFloats(direction);
        if (floats.size() > 0) {
            Point offset = bfc.getOffset();
            BoxOffset lastOffset = floats.get(floats.size() - 1);
            BlockBox last = lastOffset.getBox();
            Rectangle currentBounds = current.getMarginEdge(cssCtx, -offset.x, -offset.y);
            Rectangle lastBounds = last.getMarginEdge(cssCtx, -lastOffset.getX(), -lastOffset.getY());
            boolean moveOver = false;
            if (currentBounds.y < lastBounds.y) {
                currentBounds.translate(0, lastBounds.y - currentBounds.y);
                moveOver = true;
            }
            if (currentBounds.y >= lastBounds.y && currentBounds.y < lastBounds.y + lastBounds.height) {
                moveOver = true;
            }
            if (moveOver) {
                if (direction == FloatDirection.LEFT) {
                    currentBounds.x = lastBounds.x + last.getWidth();
                } else if (direction == FloatDirection.RIGHT) {
                    currentBounds.x = lastBounds.x - current.getWidth();
                }
                currentBounds.translate(offset.x, offset.y);
                current.setX(currentBounds.x);
                current.setY(currentBounds.y);
            }
        }
    }

    private void alignToLastOpposingFloat(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, FloatDirection direction) {
        List<BoxOffset> floats = this.getOpposingFloats(direction);
        if (!floats.isEmpty()) {
            Point offset = bfc.getOffset();
            BoxOffset lastOffset = floats.get(floats.size() - 1);
            Rectangle currentBounds = current.getMarginEdge(cssCtx, -offset.x, -offset.y);
            Rectangle lastBounds = lastOffset.getBox().getMarginEdge(cssCtx, -lastOffset.getX(), -lastOffset.getY());
            if (currentBounds.y < lastBounds.y) {
                currentBounds.translate(0, lastBounds.y - currentBounds.y);
                currentBounds.translate(offset.x, offset.y);
                current.setY(currentBounds.y);
            }
        }
    }

    private void moveAllTheWayOver(BlockBox current, FloatDirection direction) {
        if (direction == FloatDirection.LEFT) {
            current.setX(0);
        } else if (direction == FloatDirection.RIGHT) {
            current.setX(current.getContainingBlock().getContentWidth() - current.getWidth());
        }
    }

    private boolean fitsInContainingBlock(BlockBox current) {
        return current.getX() >= 0 && current.getX() + current.getWidth() <= current.getContainingBlock().getContentWidth();
    }

    private int findLowestY(CssContext cssCtx, List<BoxOffset> floats) {
        return floats.stream().map(floater -> floater.getBox().getMarginEdge(cssCtx, -floater.getX(), -floater.getY())).mapToInt(bounds -> bounds.y + bounds.height).max().orElse(0);
    }

    public int getClearDelta(CssContext cssCtx, int bfcRelativeY) {
        int lowestLeftY = this.findLowestY(cssCtx, this.getFloats(FloatDirection.LEFT));
        int lowestRightY = this.findLowestY(cssCtx, this.getFloats(FloatDirection.RIGHT));
        int lowestY = Math.max(lowestLeftY, lowestRightY);
        return lowestY - bfcRelativeY;
    }

    private boolean overlaps(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, List<BoxOffset> floats) {
        Point offset = bfc.getOffset();
        Rectangle bounds = current.getMarginEdge(cssCtx, -offset.x, -offset.y);
        return floats.stream().map(floater -> floater.getBox().getMarginEdge(cssCtx, -floater.getX(), -floater.getY())).anyMatch(floaterBounds -> floaterBounds.intersects(bounds));
    }

    private void moveFloatBelow(CssContext cssCtx, BlockFormattingContext bfc, Box current, List<BoxOffset> floats) {
        if (floats.isEmpty()) {
            return;
        }
        Point offset = bfc.getOffset();
        int boxY = current.getY() - offset.y;
        int floatY = this.findLowestY(cssCtx, floats);
        if (floatY - boxY > 0) {
            current.setY(current.getY() + (floatY - boxY));
        }
    }

    private void moveClear(CssContext cssCtx, BlockFormattingContext bfc, Box current, List<BoxOffset> floats) {
        if (floats.isEmpty()) {
            return;
        }
        Point offset = bfc.getOffset();
        Rectangle bounds = current.getBorderEdge(current.getX() - offset.x, current.getY() - offset.y, cssCtx);
        int y = this.findLowestY(cssCtx, floats);
        if (bounds.y < y) {
            bounds.y = y;
            bounds.translate(offset.x, offset.y);
            current.setY(bounds.y - (int)current.getMargin(cssCtx).top());
        }
    }

    public void removeFloat(BlockBox floater) {
        this.removeFloat(floater, this.getFloats(FloatDirection.LEFT));
        this.removeFloat(floater, this.getFloats(FloatDirection.RIGHT));
    }

    private void removeFloat(BlockBox floater, List<BoxOffset> floats) {
        Iterator<BoxOffset> i = floats.iterator();
        while (i.hasNext()) {
            BoxOffset boxOffset = i.next();
            if (!boxOffset.getBox().equals(floater)) continue;
            i.remove();
            floater.getFloatedBoxData().setManager(null);
        }
    }

    public void calcFloatLocations() {
        this.calcFloatLocations(this.getFloats(FloatDirection.LEFT));
        this.calcFloatLocations(this.getFloats(FloatDirection.RIGHT));
    }

    private void calcFloatLocations(List<BoxOffset> floats) {
        for (BoxOffset boxOffset : floats) {
            boxOffset.getBox().calcCanvasLocation();
            boxOffset.getBox().calcChildLocations();
        }
    }

    private void applyLineHeightHack(CssContext cssCtx, Box line, Rectangle bounds) {
        if (line.getHeight() == 0) {
            bounds.height = (int)line.getStyle().getLineHeight(cssCtx);
        }
    }

    public int getNextLineBoxDelta(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth) {
        BoxDistance left = this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this.getFloats(FloatDirection.LEFT), FloatDirection.LEFT);
        BoxDistance right = this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this.getFloats(FloatDirection.RIGHT), FloatDirection.RIGHT);
        int leftDelta = left.getBox() != null ? this.calcDelta(cssCtx, line, left) : 0;
        int rightDelta = right.getBox() != null ? this.calcDelta(cssCtx, line, right) : 0;
        return Math.max(leftDelta, rightDelta);
    }

    private int calcDelta(CssContext cssCtx, LineBox line, BoxDistance boxDistance) {
        BlockBox floated = boxDistance.getBox();
        Rectangle rect = floated.getBorderEdge(floated.getAbsX(), floated.getAbsY(), cssCtx);
        RectPropertySet margin = floated.getMargin(cssCtx);
        int bottom = (int)Math.ceil((float)(rect.y + rect.height) + margin.bottom());
        return bottom - line.getAbsY();
    }

    public int getLeftFloatDistance(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth) {
        return this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this.getFloats(FloatDirection.LEFT), FloatDirection.LEFT).getDistance();
    }

    public int getRightFloatDistance(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth) {
        return this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this.getFloats(FloatDirection.RIGHT), FloatDirection.RIGHT).getDistance();
    }

    private BoxDistance getFloatDistance(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth, List<BoxOffset> floatsList, FloatDirection direction) {
        if (floatsList.isEmpty()) {
            return new BoxDistance(null, 0);
        }
        Point offset = bfc.getOffset();
        Rectangle lineBounds = line.getMarginEdge(cssCtx, -offset.x, -offset.y);
        lineBounds.width = containingBlockContentWidth;
        int farthestOver = direction == FloatDirection.LEFT ? lineBounds.x : lineBounds.x + lineBounds.width;
        this.applyLineHeightHack(cssCtx, line, lineBounds);
        BlockBox farthestOverBox = null;
        for (BoxOffset floater : floatsList) {
            Rectangle fr = floater.getBox().getMarginEdge(cssCtx, -floater.getX(), -floater.getY());
            if (!lineBounds.intersects(fr)) continue;
            if (direction == FloatDirection.LEFT && fr.x + fr.width > farthestOver) {
                farthestOver = fr.x + fr.width;
            } else if (direction == FloatDirection.RIGHT && fr.x < farthestOver) {
                farthestOver = fr.x;
            }
            farthestOverBox = floater.getBox();
        }
        if (direction == FloatDirection.LEFT) {
            return new BoxDistance(farthestOverBox, farthestOver - lineBounds.x);
        }
        return new BoxDistance(farthestOverBox, lineBounds.x + lineBounds.width - farthestOver);
    }

    public Box getMaster() {
        return this._master;
    }

    public Point getOffset(BlockBox floater) {
        return this.getOffset(floater, this.getFloatStream(floater.getStyle().isFloatedLeft() ? FloatDirection.LEFT : FloatDirection.RIGHT));
    }

    private Point getOffset(BlockBox floater, Stream<BoxOffset> floats) {
        return floats.filter(boxOffset -> boxOffset.getBox().equals(floater)).findFirst().map(boxOffset -> new Point(boxOffset.getX(), boxOffset.getY())).orElse(null);
    }

    private void performFloatOperation(FloatOperation op, List<BoxOffset> floats) {
        for (BoxOffset boxOffset : floats) {
            BlockBox box = boxOffset.getBox();
            box.setAbsX(box.getX() + this.getMaster().getAbsX() - boxOffset.getX());
            box.setAbsY(box.getY() + this.getMaster().getAbsY() - boxOffset.getY());
            op.operate(box);
        }
    }

    public void performFloatOperation(FloatOperation op) {
        this.performFloatOperation(op, this.getFloats(FloatDirection.LEFT));
        this.performFloatOperation(op, this.getFloats(FloatDirection.RIGHT));
    }

    public static enum FloatDirection {
        LEFT,
        RIGHT;

    }

    public static class BoxOffset {
        private final BlockBox _box;
        private final int _x;
        private final int _y;

        public BoxOffset(BlockBox box, int x, int y) {
            this._box = box;
            this._x = x;
            this._y = y;
        }

        public BlockBox getBox() {
            return this._box;
        }

        public int getX() {
            return this._x;
        }

        public int getY() {
            return this._y;
        }
    }

    private static class BoxDistance {
        private final BlockBox _box;
        private final int _distance;

        public BoxDistance(BlockBox box, int distance) {
            this._box = box;
            this._distance = distance;
        }

        BlockBox getBox() {
            return this._box;
        }

        int getDistance() {
            return this._distance;
        }

        public String toString() {
            return "BoxDistance [_box=" + this._box + ", _distance=" + this._distance + "]";
        }
    }

    @FunctionalInterface
    public static interface FloatOperation {
        public void operate(Box var1);
    }
}

