/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.event.DocumentListener;
import com.openhtmltopdf.extend.FSStream;
import com.openhtmltopdf.extend.FSStreamFactory;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    protected final LinkedHashMap<String, ImageResource> _imageCache = new LinkedHashMap();
    protected final FSUriResolver DEFAULT_URI_RESOLVER;
    protected FSUriResolver _resolver = this.DEFAULT_URI_RESOLVER = new DefaultUriResolver();
    protected String _baseUri;
    protected Map<String, FSStreamFactory> _protocolsStreamFactory = new HashMap<String, FSStreamFactory>(2);

    public NaiveUserAgent() {
        DefaultHttpStreamFactory factory = new DefaultHttpStreamFactory();
        this._protocolsStreamFactory.put("http", factory);
        this._protocolsStreamFactory.put("https", factory);
        this._protocolsStreamFactory.put("data", new DataUriFactory());
    }

    public void setProtocolsStreamFactory(Map<String, FSStreamFactory> protocolsStreamFactory) {
        this._protocolsStreamFactory = protocolsStreamFactory;
    }

    public void setUriResolver(FSUriResolver resolver) {
        this._resolver = resolver;
    }

    public FSUriResolver getDefaultUriResolver() {
        return this.DEFAULT_URI_RESOLVER;
    }

    @Deprecated
    public void clearImageCache() {
        this._imageCache.clear();
    }

    protected FSStreamFactory getProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.get(protocol);
    }

    protected boolean hasProtocolFactory(String protocol) {
        return this._protocolsStreamFactory.containsKey(protocol);
    }

    protected String extractProtocol(String uri) throws URISyntaxException {
        int idxSeparator;
        if (uri != null && (idxSeparator = uri.indexOf(58)) > 0) {
            return uri.substring(0, idxSeparator);
        }
        throw new URISyntaxException(uri, "missing protocol for URI");
    }

    protected InputStream openStream(String uri) {
        InputStream is = null;
        try {
            String protocol = this.extractProtocol(uri);
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getStream();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, (Object)uri, e);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_IO_PROBLEM_FOR_URI, (Object)uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e1);
        }
        return is;
    }

    protected Reader openReader(String uri) {
        InputStream is = null;
        try {
            String protocol = this.extractProtocol(uri);
            if (this.hasProtocolFactory(protocol)) {
                return this.getProtocolFactory(protocol).getUrl(uri).getReader();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, (Object)uri, e);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_IO_PROBLEM_FOR_URI, (Object)uri, e);
            }
        }
        catch (URISyntaxException e1) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e1);
        }
        return is == null ? null : new InputStreamReader(is, StandardCharsets.UTF_8);
    }

    protected String readAll(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    @Override
    public CSSResource getCSSResource(String uri) {
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"CSS resource", (Object)uri);
            return null;
        }
        return new CSSResource(this.openReader(resolved));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageResource getImageResource(String uri) {
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"image resource", (Object)uri);
            return null;
        }
        ImageResource ir = this._imageCache.get(resolved);
        if (ir != null) {
            return ir;
        }
        InputStream is = this.openStream(resolved);
        if (is != null) {
            try {
                BufferedImage img = ImageIO.read(is);
                if (img == null) {
                    throw new IOException("ImageIO.read() returned null");
                }
                AWTFSImage fsImage2 = (AWTFSImage)AWTFSImage.createImage(img);
                ir = new ImageResource(resolved, fsImage2);
                this._imageCache.put(resolved, ir);
                ImageResource imageResource = ir;
                return imageResource;
            }
            catch (FileNotFoundException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_CANT_READ_IMAGE_FILE_FOR_URI_NOT_FOUND, resolved);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_CANT_READ_IMAGE_FILE_FOR_URI, (Object)uri, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return new ImageResource(resolved, null);
    }

    @Override
    public XMLResource getXMLResource(String uri) {
        XMLResource xMLResource;
        block9: {
            String resolved = this._resolver.resolveURI(this._baseUri, uri);
            if (resolved == null) {
                XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"XML resource", (Object)uri);
                return null;
            }
            Reader inputReader = this.openReader(resolved);
            try {
                XMLResource xMLResource2 = xMLResource = inputReader == null ? null : XMLResource.load(inputReader);
                if (inputReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputReader != null) {
                        try {
                            inputReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputReader.close();
        }
        return xMLResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBinaryResource(String uri) {
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (resolved == null) {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"binary resource", (Object)uri);
            return null;
        }
        InputStream is = this.openStream(resolved);
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes2;
            int i;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byte[] byArray = bytes2 = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String uri) {
        this._baseUri = uri;
    }

    @Override
    public String getBaseURL() {
        return this._baseUri;
    }

    @Override
    @Deprecated
    public void documentStarted() {
        this.clearImageCache();
    }

    @Override
    @Deprecated
    public void documentLoaded() {
    }

    @Override
    @Deprecated
    public void onLayoutException(Throwable t) {
    }

    @Override
    @Deprecated
    public void onRenderException(Throwable t) {
    }

    @Override
    public String resolveURI(String uri) {
        return this._resolver.resolveURI(this.getBaseURL(), uri);
    }

    @Override
    public String resolveUri(String baseUri, String uri) {
        return this._resolver.resolveURI(baseUri, uri);
    }

    public static class DefaultUriResolver
    implements FSUriResolver {
        @Override
        public String resolveURI(String baseUri, String uri) {
            if (uri == null || uri.isEmpty()) {
                return null;
            }
            try {
                URI possiblyRelative = new URI(uri);
                if (possiblyRelative.isAbsolute()) {
                    return possiblyRelative.toString();
                }
                if (baseUri == null) {
                    XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.LOAD_COULD_NOT_RESOLVE_RELATIVE_URI_BECAUSE_NO_BASE_URI_WAS_PROVIDED, uri);
                    return null;
                }
                if (baseUri.startsWith("jar")) {
                    URL base = new URL(baseUri);
                    URL absolute = new URL(base, uri);
                    return absolute.toString();
                }
                URI base = new URI(baseUri);
                URI absolute = base.resolve(uri);
                return absolute.toString();
            }
            catch (URISyntaxException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId3Param.EXCEPTION_URI_WITH_BASE_URI_INVALID, (Object)uri, (Object)"", (Object)baseUri, e);
                return null;
            }
            catch (MalformedURLException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId3Param.EXCEPTION_URI_WITH_BASE_URI_INVALID, (Object)uri, (Object)"jar scheme", (Object)baseUri, e);
                return null;
            }
        }
    }

    public static class DefaultHttpStreamFactory
    implements FSStreamFactory {
        @Override
        public FSStream getUrl(String uri) {
            InputStream is = null;
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, (Object)uri, e);
            }
            catch (IOException e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_IO_PROBLEM_FOR_URI, (Object)uri, e);
            }
            return new DefaultHttpStream(is);
        }
    }

    public static class DataUriFactory
    implements FSStreamFactory {
        @Override
        public FSStream getUrl(String url) {
            int idxSeparator;
            if (url != null && url.startsWith("data:") && (idxSeparator = url.indexOf(44)) > 0) {
                String data = url.substring(idxSeparator + 1);
                byte[] res = url.indexOf("base64,") == idxSeparator - 6 ? Base64.getMimeDecoder().decode(data) : data.getBytes(StandardCharsets.UTF_8);
                return new ByteStream(res);
            }
            return null;
        }
    }

    private static class ByteStream
    implements FSStream {
        private final byte[] input;

        ByteStream(byte[] input) {
            this.input = input;
        }

        @Override
        public InputStream getStream() {
            return new ByteArrayInputStream(this.input);
        }

        @Override
        public Reader getReader() {
            return new InputStreamReader(this.getStream(), StandardCharsets.UTF_8);
        }
    }

    public static class DefaultHttpStream
    implements FSStream {
        private InputStream strm;

        public DefaultHttpStream(InputStream strm) {
            this.strm = strm;
        }

        @Override
        public InputStream getStream() {
            return this.strm;
        }

        @Override
        public Reader getReader() {
            if (this.strm != null) {
                return new InputStreamReader(this.strm, StandardCharsets.UTF_8);
            }
            return null;
        }
    }
}

