/*
 * Decompiled with CFR 0.152.
 */
package com.ning.maven.plugins.duplicatefinder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ClasspathDescriptor {
    private static final Pattern[] DEFAULT_IGNORED_RESOURCES = new Pattern[]{Pattern.compile("(META-INF/)?ASL2\\.0(\\.TXT)?"), Pattern.compile("META-INF/DEPENDENCIES(\\.TXT)?"), Pattern.compile("META-INF/DISCLAIMER(\\.TXT)?"), Pattern.compile("(META-INF/)?[A-Z_-]*LICENSE.*"), Pattern.compile("META-INF/MANIFEST\\.MF"), Pattern.compile("META-INF/INDEX\\.LIST"), Pattern.compile("META-INF/MAVEN/.*"), Pattern.compile("META-INF/PLEXUS/.*"), Pattern.compile("META-INF/SERVICES/.*"), Pattern.compile("(META-INF/)?NOTICE(\\.TXT)?"), Pattern.compile("META-INF/README"), Pattern.compile("OSGI-INF/.*"), Pattern.compile("README(\\.TXT)?"), Pattern.compile(".*PACKAGE\\.HTML"), Pattern.compile(".*OVERVIEW\\.HTML"), Pattern.compile("META-INF/SPRING\\.HANDLERS"), Pattern.compile("META-INF/SPRING\\.SCHEMAS"), Pattern.compile("META-INF/SPRING\\.TOOLING")};
    private static final Set IGNORED_LOCAL_DIRECTORIES = new HashSet();
    private static final Map CACHED_BY_ELEMENT = new HashMap();
    private Map classesWithElements = new TreeMap();
    private Map resourcesWithElements = new TreeMap();
    private boolean useDefaultResourceIgnoreList = true;
    private Pattern[] ignoredResourcesPatterns = null;

    public boolean isUseDefaultResourceIgnoreList() {
        return this.useDefaultResourceIgnoreList;
    }

    public void setUseDefaultResourceIgnoreList(boolean useDefaultResourceIgnoreList) {
        this.useDefaultResourceIgnoreList = useDefaultResourceIgnoreList;
    }

    public void setIgnoredResources(String[] ignoredResources) throws MojoExecutionException {
        if (ignoredResources != null) {
            this.ignoredResourcesPatterns = new Pattern[ignoredResources.length];
            try {
                for (int i = 0; i < ignoredResources.length; ++i) {
                    this.ignoredResourcesPatterns[i] = Pattern.compile(ignoredResources[i].toUpperCase(Locale.ENGLISH));
                }
            }
            catch (PatternSyntaxException pse) {
                throw new MojoExecutionException("Error compiling resourceIgnore pattern: " + pse.getMessage());
            }
        }
    }

    public void add(File element) throws IOException {
        if (!element.exists()) {
            throw new FileNotFoundException("Path " + element + " doesn't exist");
        }
        if (element.isDirectory()) {
            this.addDirectory(element);
        } else {
            this.addArchive(element);
        }
    }

    public Set getClasss() {
        return Collections.unmodifiableSet(this.classesWithElements.keySet());
    }

    public Set getResources() {
        return Collections.unmodifiableSet(this.resourcesWithElements.keySet());
    }

    public Set getElementsHavingClass(String className) {
        Set elements = (Set)this.classesWithElements.get(className);
        return elements == null ? null : Collections.unmodifiableSet(elements);
    }

    public Set getElementsHavingResource(String resource) {
        Set elements = (Set)this.resourcesWithElements.get(resource);
        return elements == null ? null : Collections.unmodifiableSet(elements);
    }

    private void addDirectory(File element) {
        this.addDirectory(element, null, element);
    }

    private void addDirectory(File element, String parentPackageName, File directory) {
        String pckgName;
        if (this.addCached(element)) {
            return;
        }
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<String> resources = new ArrayList<String>();
        File[] files = directory.listFiles();
        String string = element.equals(directory) ? null : (pckgName = (parentPackageName == null ? "" : parentPackageName + ".") + directory.getName());
        if (files != null && files.length > 0) {
            for (int idx = 0; idx < files.length; ++idx) {
                if (files[idx].isDirectory() && !IGNORED_LOCAL_DIRECTORIES.contains(files[idx].getName().toUpperCase(Locale.ENGLISH))) {
                    this.addDirectory(element, pckgName, files[idx]);
                    continue;
                }
                if (!files[idx].isFile()) continue;
                if ("class".equals(FilenameUtils.getExtension((String)files[idx].getName()))) {
                    String className = (pckgName == null ? "" : pckgName + ".") + FilenameUtils.getBaseName((String)files[idx].getName());
                    classes.add(className);
                    this.addClass(className, element);
                    continue;
                }
                String resourcePath = (pckgName == null ? "" : pckgName.replace('.', '/') + "/") + files[idx].getName();
                resources.add(resourcePath);
                this.addResource(resourcePath, element);
            }
        }
        CACHED_BY_ELEMENT.put(element, new Cached(classes, resources));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArchive(File element) throws IOException {
        block10: {
            InputStream input;
            block9: {
                if (this.addCached(element)) {
                    return;
                }
                ArrayList<String> classes = new ArrayList<String>();
                ArrayList<String> resources = new ArrayList<String>();
                input = null;
                ZipInputStream zipInput = null;
                try {
                    ZipEntry entry;
                    input = element.toURI().toURL().openStream();
                    zipInput = new ZipInputStream(input);
                    while ((entry = zipInput.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        String name = entry.getName();
                        if ("class".equals(FilenameUtils.getExtension((String)name))) {
                            String className = FilenameUtils.removeExtension((String)name).replace('/', '.').replace('\\', '.');
                            classes.add(className);
                            this.addClass(className, element);
                            continue;
                        }
                        String resourcePath = name.replace('\\', File.separatorChar);
                        resources.add(resourcePath);
                        this.addResource(resourcePath, element);
                    }
                    CACHED_BY_ELEMENT.put(element, new Cached(classes, resources));
                    if (zipInput == null) break block9;
                }
                catch (Throwable throwable) {
                    if (zipInput != null) {
                        IOUtils.closeQuietly(zipInput);
                    } else if (input != null) {
                        IOUtils.closeQuietly((InputStream)input);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)zipInput);
                break block10;
            }
            if (input != null) {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    private void addClass(String className, File element) {
        if (className.indexOf(36) < 0) {
            HashSet<File> elements = (HashSet<File>)this.classesWithElements.get(className);
            if (elements == null) {
                elements = new HashSet<File>();
                this.classesWithElements.put(className, elements);
            }
            elements.add(element);
        }
    }

    private void addResource(String path, File element) {
        if (!this.ignore(path)) {
            HashSet<File> elements = (HashSet<File>)this.resourcesWithElements.get(path);
            if (elements == null) {
                elements = new HashSet<File>();
                this.resourcesWithElements.put(path, elements);
            }
            elements.add(element);
        }
    }

    private boolean ignore(String path) {
        int idx;
        String uppercasedPath = path.toUpperCase(Locale.ENGLISH).replace(File.separatorChar, '/');
        if (this.useDefaultResourceIgnoreList) {
            for (idx = 0; idx < DEFAULT_IGNORED_RESOURCES.length; ++idx) {
                if (!DEFAULT_IGNORED_RESOURCES[idx].matcher(uppercasedPath).matches()) continue;
                return true;
            }
        }
        if (this.ignoredResourcesPatterns != null) {
            for (idx = 0; idx < this.ignoredResourcesPatterns.length; ++idx) {
                if (!this.ignoredResourcesPatterns[idx].matcher(uppercasedPath).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean addCached(File element) {
        Cached cached = (Cached)CACHED_BY_ELEMENT.get(element);
        if (cached == null) {
            return false;
        }
        Iterator cachedClasses = cached.getClasses().iterator();
        Iterator cachedResources = cached.getResources().iterator();
        while (cachedClasses.hasNext()) {
            this.addClass((String)cachedClasses.next(), element);
        }
        while (cachedResources.hasNext()) {
            this.addResource((String)cachedResources.next(), element);
        }
        return true;
    }

    static {
        IGNORED_LOCAL_DIRECTORIES.add(".GIT");
        IGNORED_LOCAL_DIRECTORIES.add(".SVN");
        IGNORED_LOCAL_DIRECTORIES.add(".HG");
        IGNORED_LOCAL_DIRECTORIES.add(".BZR");
    }

    private static class Cached {
        private final List classes;
        private final List resources;

        private Cached(List classes, List resources) {
            this.classes = classes;
            this.resources = resources;
        }

        public List getClasses() {
            return this.classes;
        }

        public List getResources() {
            return this.resources;
        }
    }
}

