/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util.batcher;

import com.netflix.eureka.util.batcher.TaskProcessor;

class TrafficShaper {
    private static final long MAX_DELAY = 30000L;
    private final long congestionRetryDelayMs;
    private final long networkFailureRetryMs;
    private volatile long lastCongestionError;
    private volatile long lastNetworkFailure;

    TrafficShaper(long congestionRetryDelayMs, long networkFailureRetryMs) {
        this.congestionRetryDelayMs = Math.min(30000L, congestionRetryDelayMs);
        this.networkFailureRetryMs = Math.min(30000L, networkFailureRetryMs);
    }

    void registerFailure(TaskProcessor.ProcessingResult processingResult) {
        if (processingResult == TaskProcessor.ProcessingResult.Congestion) {
            this.lastCongestionError = System.currentTimeMillis();
        } else if (processingResult == TaskProcessor.ProcessingResult.TransientError) {
            this.lastNetworkFailure = System.currentTimeMillis();
        }
    }

    long transmissionDelay() {
        if (this.lastCongestionError == -1L && this.lastNetworkFailure == -1L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        if (this.lastCongestionError != -1L) {
            long congestionDelay = now - this.lastCongestionError;
            if (congestionDelay >= 0L && congestionDelay < this.congestionRetryDelayMs) {
                return this.congestionRetryDelayMs - congestionDelay;
            }
            this.lastCongestionError = -1L;
        }
        if (this.lastNetworkFailure != -1L) {
            long failureDelay = now - this.lastNetworkFailure;
            if (failureDelay >= 0L && failureDelay < this.networkFailureRetryMs) {
                return this.networkFailureRetryMs - failureDelay;
            }
            this.lastNetworkFailure = -1L;
        }
        return 0L;
    }
}

