/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.util.StatusInfo;
import com.netflix.eureka.util.StatusUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{version}/status")
@Produces(value={"application/xml", "application/json"})
public class StatusResource {
    private static final Logger logger = LoggerFactory.getLogger(StatusResource.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    private final StatusUtil statusUtil;

    @Inject
    StatusResource(EurekaServerContext server) {
        this.statusUtil = new StatusUtil(server);
    }

    public StatusResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    @GET
    public StatusInfo getStatusInfo() {
        return this.statusUtil.getStatusInfo();
    }

    public static String getCurrentTimeAsString() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        return format.format(new Date());
    }
}

