/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.mapper;

import com.netflix.archaius.Config;
import com.netflix.archaius.Decoder;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.Property;
import com.netflix.archaius.PropertyFactory;
import com.netflix.archaius.annotations.Configuration;
import com.netflix.archaius.annotations.DefaultValue;
import com.netflix.archaius.exceptions.MappingException;
import com.netflix.archaius.mapper.ConfigMapper;
import com.netflix.archaius.mapper.IoCContainer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.commons.lang3.text.StrSubstitutor;

public class DefaultConfigMapper
implements ConfigMapper {
    private static final IoCContainer NULL_IOC_CONTAINER = new IoCContainer(){

        @Override
        public <T> T getInstance(String name, Class<T> type) {
            return null;
        }
    };
    private final boolean allowPostConfigure;
    private final Decoder decoder = new DefaultDecoder();

    public DefaultConfigMapper() {
        this(true);
    }

    public DefaultConfigMapper(boolean allowPostConfigure) {
        this.allowPostConfigure = allowPostConfigure;
    }

    @Override
    public <T> void mapConfig(T injectee, Config config) throws MappingException {
        this.mapConfig(injectee, config, NULL_IOC_CONTAINER);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> void mapConfig(T injectee, Config config, IoCContainer ioc) throws MappingException {
        String objName;
        Object value;
        Class<?> type;
        String name;
        Configuration configAnnot = injectee.getClass().getAnnotation(Configuration.class);
        if (configAnnot == null) {
            return;
        }
        Class<?> injecteeType = injectee.getClass();
        String prefix = configAnnot.prefix();
        String[] params = configAnnot.params();
        if (params.length > 0) {
            void var11_15;
            HashMap<String, String> map = new HashMap<String, String>();
            String[] arr$ = params;
            int len$ = arr$.length;
            boolean bl = false;
            while (var11_15 < len$) {
                String param = arr$[var11_15];
                try {
                    Field f = injecteeType.getDeclaredField(param);
                    f.setAccessible(true);
                    map.put(param, f.get(injectee).toString());
                }
                catch (NoSuchFieldException e) {
                    try {
                        Method method = injecteeType.getDeclaredMethod("get" + Character.toUpperCase(param.charAt(0)) + param.substring(1), new Class[0]);
                        method.setAccessible(true);
                        map.put(param, method.invoke(injectee, new Object[0]).toString());
                    }
                    catch (Exception e1) {
                        throw new MappingException(e1);
                    }
                }
                catch (Exception e) {
                    throw new MappingException(e);
                }
                ++var11_15;
            }
            prefix = StrSubstitutor.replace((Object)prefix, map, (String)"${", (String)"}");
        }
        if (!(prefix = config.getStrInterpolator().resolve(prefix).toString()).isEmpty() && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        if (configAnnot.allowFields()) {
            for (AccessibleObject accessibleObject : injecteeType.getDeclaredFields()) {
                if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                name = ((Field)accessibleObject).getName();
                type = ((Field)accessibleObject).getType();
                value = null;
                if (type.isInterface()) {
                    objName = config.getString(prefix + name, null);
                    if (objName != null) {
                        value = ioc.getInstance(objName, type);
                    }
                } else {
                    value = config.get(type, prefix + name, null);
                }
                if (value == null) continue;
                try {
                    ((Field)accessibleObject).setAccessible(true);
                    ((Field)accessibleObject).set(injectee, value);
                }
                catch (Exception e) {
                    throw new MappingException("Unable to inject field " + injectee.getClass() + "." + name + " with value " + value, e);
                }
            }
        }
        if (configAnnot.allowSetters()) {
            for (AccessibleObject accessibleObject : injectee.getClass().getDeclaredMethods()) {
                if (((Method)accessibleObject).getParameterTypes().length != 1) continue;
                name = ((Method)accessibleObject).getName();
                if (name.startsWith("set") && name.length() > 3) {
                    name = name.substring(3, 4).toLowerCase() + name.substring(4);
                } else {
                    if (!name.startsWith("with") || name.length() <= 4) continue;
                    name = name.substring(4, 1).toLowerCase() + name.substring(5);
                }
                ((Method)accessibleObject).setAccessible(true);
                type = ((Method)accessibleObject).getParameterTypes()[0];
                value = null;
                if (type.isInterface()) {
                    objName = config.getString(prefix + name, null);
                    if (objName != null) {
                        value = ioc.getInstance(objName, type);
                    }
                } else {
                    value = config.get(type, prefix + name, null);
                }
                if (value == null) continue;
                try {
                    ((Method)accessibleObject).invoke(injectee, value);
                }
                catch (Exception e) {
                    throw new MappingException("Unable to inject field " + injectee.getClass() + "." + name + " with value " + value, e);
                }
            }
        }
        if (!configAnnot.postConfigure().isEmpty()) {
            try {
                Method m = injecteeType.getMethod(configAnnot.postConfigure(), new Class[0]);
                m.invoke(injectee, new Object[0]);
            }
            catch (Exception e) {
                throw new MappingException("Unable to invoke postConfigure method " + configAnnot.postConfigure(), e);
            }
        }
    }

    @Override
    public <T> T newProxy(Class<T> type, PropertyFactory factory) {
        Configuration annot = type.getAnnotation(Configuration.class);
        String prefix = annot == null ? "" : (!annot.prefix().isEmpty() && !annot.prefix().endsWith(".") ? annot.prefix() + "." : annot.prefix());
        final HashMap<Method, Property<Object>> properties = new HashMap<Method, Property<Object>>();
        for (Method m : type.getDeclaredMethods()) {
            if (!m.getName().startsWith("get")) continue;
            Object defaultValue = null;
            DefaultValue annotDefaultValue = m.getAnnotation(DefaultValue.class);
            Class<?> returnType = m.getReturnType();
            if (annotDefaultValue != null) {
                try {
                    defaultValue = this.decoder.decode(returnType, annotDefaultValue.value());
                }
                catch (Exception e) {
                    throw new RuntimeException("No accessible valueOf(String) method to parse default value for type " + returnType.getName(), e);
                }
            }
            if (returnType.isPrimitive() && defaultValue == null) {
                throw new RuntimeException("Method with primite return type must have a @DefaultValue.  method=" + m.getName());
            }
            String propName = prefix + Character.toLowerCase(m.getName().charAt(3)) + m.getName().substring(4);
            properties.put(m, factory.getProperty(propName).asType(m.getReturnType(), defaultValue));
        }
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return ((Property)properties.get(method)).get();
            }
        };
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, handler);
    }
}

