/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.interpolate;

import com.netflix.archaius.Config;
import com.netflix.archaius.StrInterpolator;
import com.netflix.archaius.StrInterpolatorFactory;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;

public class CommonsStrInterpolatorFactory
implements StrInterpolatorFactory {
    public static CommonsStrInterpolatorFactory INSTANCE = new CommonsStrInterpolatorFactory();

    @Override
    public StrInterpolator create(Config rootConfig) {
        return new InternalInterpolator(rootConfig);
    }

    class InternalInterpolator
    extends StrLookup
    implements StrInterpolator {
        private final Config config;
        private final StrSubstitutor sub;

        public InternalInterpolator(Config config) {
            this.config = config;
            this.sub = new StrSubstitutor((StrLookup)this, "${", "}", '$');
        }

        @Override
        public String resolve(String key) {
            return this.sub.replace(key);
        }

        public String lookup(String key) {
            return this.config.getRawString(key);
        }
    }
}

