/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config.polling;

import com.netflix.archaius.config.PollingStrategy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ManualPollingStrategy
implements PollingStrategy {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final LinkedBlockingQueue<Request> queue = new LinkedBlockingQueue();

    @Override
    public Future<?> execute(final Runnable run) {
        return this.executor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Request request;
                    while (null != (request = (Request)ManualPollingStrategy.this.queue.take())) {
                        try {
                            run.run();
                        }
                        catch (Exception e) {
                            request.error = e;
                        }
                        finally {
                            request.latch.countDown();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    public void fire(long timeout, TimeUnit units) throws Exception {
        Request request = new Request();
        this.queue.put(request);
        request.latch.await(timeout, units);
        if (request.error != null) {
            throw request.error;
        }
    }

    public void fire() throws Exception {
        Request request = new Request();
        this.queue.put(request);
        request.latch.await();
        if (request.error != null) {
            throw request.error;
        }
    }

    private static class Request {
        CountDownLatch latch = new CountDownLatch(1);
        Exception error;

        private Request() {
        }
    }
}

