/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.config.InterpolatingConfig;
import com.netflix.archaius.config.PollingStrategy;
import com.netflix.archaius.config.polling.PollingResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingDynamicConfig
extends InterpolatingConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PollingDynamicConfig.class);
    private volatile Map<String, String> current = new HashMap<String, String>();
    private final AtomicBoolean busy = new AtomicBoolean();
    private final Callable<PollingResponse> reader;

    public PollingDynamicConfig(String name, Callable<PollingResponse> reader, PollingStrategy strategy) {
        super(name);
        this.reader = reader;
        strategy.execute(new Runnable(){

            @Override
            public void run() {
                PollingDynamicConfig.this.update();
            }
        });
    }

    @Override
    public boolean containsKey(String key) {
        return this.current.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.current.isEmpty();
    }

    @Override
    public String getRawString(String key) {
        return this.current.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (this.busy.compareAndSet(false, true)) {
            try {
                PollingResponse response = this.reader.call();
                if (response.hasData()) {
                    this.current = response.getToAdd();
                    this.notifyConfigUpdated();
                }
            }
            catch (Exception e) {
                try {
                    this.notifyError(e);
                }
                catch (Exception e2) {
                    LOG.warn("Failed to notify error observer for config " + this.getName());
                }
            }
            finally {
                this.busy.set(false);
            }
        }
    }

    @Override
    public Iterator<String> getKeys() {
        return this.current.keySet().iterator();
    }
}

