/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigListener;
import java.util.List;

public class ForwardingConfigListener
implements ConfigListener {
    private final List<ConfigListener> listeners;
    private final Config config;

    public ForwardingConfigListener(List<ConfigListener> listeners, Config config) {
        this.listeners = listeners;
        this.config = config;
    }

    @Override
    public void onConfigAdded(Config config) {
        this.onConfigUpdated(config);
    }

    @Override
    public void onConfigRemoved(Config config) {
        this.onConfigUpdated(config);
    }

    @Override
    public void onConfigUpdated(Config config) {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigUpdated(this.config);
        }
    }

    @Override
    public void onError(Throwable error, Config config) {
        for (ConfigListener listener : this.listeners) {
            listener.onError(error, config);
        }
    }
}

