/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius.config;

import com.netflix.archaius.Config;
import com.netflix.archaius.config.AbstractConfig;
import com.netflix.archaius.config.PrefixedViewConfig;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class DelegatingConfig
extends AbstractConfig {
    public DelegatingConfig(String name) {
        super(name);
    }

    protected abstract Config getConfigWithProperty(String var1, boolean var2);

    @Override
    public String getRawString(String key) {
        Config config = this.getConfigWithProperty(key, false);
        return config != null ? config.getRawString(key) : null;
    }

    @Override
    public Long getLong(String key) {
        return this.getConfigWithProperty(key, true).getLong(key);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getLong(key);
    }

    @Override
    public String getString(String key) {
        return this.getConfigWithProperty(key, true).getString(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getString(key);
    }

    @Override
    public Double getDouble(String key) {
        return this.getConfigWithProperty(key, true).getDouble(key);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getDouble(key);
    }

    @Override
    public Integer getInteger(String key) {
        return this.getConfigWithProperty(key, true).getInteger(key);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getInteger(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getConfigWithProperty(key, true).getBoolean(key);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getBoolean(key);
    }

    @Override
    public Short getShort(String key) {
        return this.getConfigWithProperty(key, true).getShort(key);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getShort(key);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getConfigWithProperty(key, true).getBigInteger(key);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getBigInteger(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getConfigWithProperty(key, true).getBigDecimal(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getBigDecimal(key);
    }

    @Override
    public Float getFloat(String key) {
        return this.getConfigWithProperty(key, true).getFloat(key);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getFloat(key);
    }

    @Override
    public Byte getByte(String key) {
        return this.getConfigWithProperty(key, true).getByte(key);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getByte(key);
    }

    @Override
    public List<?> getList(String key) {
        return this.getConfigWithProperty(key, true).getList(key);
    }

    @Override
    public List<?> getList(String key, List<?> defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.getList(key);
    }

    @Override
    public <T> T get(Class<T> type, String key) {
        return this.getConfigWithProperty(key, true).get(type, key);
    }

    @Override
    public <T> T get(Class<T> type, String key, T defaultValue) {
        Config config = this.getConfigWithProperty(key, false);
        if (config == null) {
            return defaultValue;
        }
        return config.get(type, key);
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<String> keys = this.getKeys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result.iterator();
    }

    @Override
    public Config getPrefixedView(String prefix) {
        return new PrefixedViewConfig(prefix, this);
    }
}

