/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.archaius;

import com.netflix.archaius.CascadeStrategy;
import com.netflix.archaius.Config;
import com.netflix.archaius.ConfigLoader;
import com.netflix.archaius.ConfigReader;
import com.netflix.archaius.StrInterpolator;
import com.netflix.archaius.cascade.SimpleCascadeStrategy;
import com.netflix.archaius.config.CascadingCompositeConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.exceptions.ConfigException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigLoader
implements ConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConfigLoader.class);
    private static final SimpleCascadeStrategy DEFAULT_CASCADE_STRATEGY = new SimpleCascadeStrategy();
    private final List<ConfigReader> loaders;
    private final CascadeStrategy defaultStrategy;
    private final String includeKey;
    private final StrInterpolator interpolator;
    private final CopyOnWriteArraySet<String> alreadyLoaded;
    private final boolean defaultFailOnFirst;

    public static Builder builder() {
        return new Builder();
    }

    public DefaultConfigLoader(Builder builder) {
        this.includeKey = builder.includeKey;
        this.loaders = builder.loaders;
        this.defaultStrategy = builder.defaultStrategy;
        this.interpolator = builder.interpolator;
        this.alreadyLoaded = new CopyOnWriteArraySet();
        this.defaultFailOnFirst = builder.failOnFirst;
    }

    @Override
    public ConfigLoader.Loader newLoader() {
        return new ConfigLoader.Loader(){
            private CascadeStrategy strategy;
            private ClassLoader classLoader;
            private String name;
            private boolean failOnFirst;
            private boolean loadToSystem;
            private Properties overrides;
            {
                this.strategy = DefaultConfigLoader.this.defaultStrategy;
                this.classLoader = Thread.currentThread().getContextClassLoader();
                this.failOnFirst = DefaultConfigLoader.this.defaultFailOnFirst;
                this.loadToSystem = false;
                this.overrides = null;
            }

            @Override
            public ConfigLoader.Loader withCascadeStrategy(CascadeStrategy strategy) {
                this.strategy = strategy;
                return this;
            }

            @Override
            public ConfigLoader.Loader withClassLoader(ClassLoader classLoader) {
                this.classLoader = classLoader;
                return this;
            }

            @Override
            public ConfigLoader.Loader withName(String name) {
                this.name = name;
                return this;
            }

            @Override
            public ConfigLoader.Loader withFailOnFirst(boolean flag) {
                this.failOnFirst = flag;
                return this;
            }

            @Override
            public ConfigLoader.Loader withOverrides(Properties props) {
                this.overrides = props;
                return this;
            }

            @Override
            public ConfigLoader.Loader withLoadToSystem(boolean toSystem) {
                this.loadToSystem = toSystem;
                return this;
            }

            @Override
            public Config load(String resourceName) {
                Config config;
                if (this.name == null) {
                    this.name = resourceName;
                }
                ArrayList<Config> configs = new ArrayList<Config>();
                boolean failIfNotLoaded = this.failOnFirst;
                for (String resourcePermutationName : this.strategy.generate(resourceName, DefaultConfigLoader.this.interpolator)) {
                    block7: for (ConfigReader loader : DefaultConfigLoader.this.loaders) {
                        if (!loader.canLoad(this.classLoader, this.name)) continue;
                        String fileToLoad = resourcePermutationName;
                        do {
                            try {
                                Config config2 = loader.load(this.classLoader, resourcePermutationName, resourcePermutationName);
                                try {
                                    fileToLoad = config2.getString(DefaultConfigLoader.this.includeKey);
                                }
                                catch (Exception e) {
                                    fileToLoad = null;
                                }
                                configs.add(config2);
                            }
                            catch (ConfigException e) {
                                LOGGER.debug("could not load config '" + fileToLoad + "'", (Throwable)e);
                                continue block7;
                            }
                        } while (fileToLoad != null);
                    }
                    if (!failIfNotLoaded) continue;
                    if (configs.isEmpty()) {
                        throw new RuntimeException("Failed to load configuration resource '" + resourceName + "'");
                    }
                    failIfNotLoaded = false;
                }
                if (this.overrides != null && !this.overrides.isEmpty()) {
                    configs.add(new MapConfig(this.name, this.overrides));
                }
                if (configs.isEmpty()) {
                    return null;
                }
                if (configs.size() == 1) {
                    config = (Config)configs.get(0);
                } else {
                    CascadingCompositeConfig cConfig = new CascadingCompositeConfig(this.name);
                    Collections.reverse(configs);
                    try {
                        cConfig.addConfigs(configs);
                    }
                    catch (ConfigException e) {
                        throw new RuntimeException(e);
                    }
                    config = cConfig;
                }
                if (this.loadToSystem) {
                    Iterator<String> keys = config.getKeys();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        System.setProperty(key, config.getString(key));
                    }
                }
                return config;
            }

            @Override
            public Config load(URL url) {
                for (ConfigReader loader : DefaultConfigLoader.this.loaders) {
                    if (!loader.canLoad(this.classLoader, this.name)) continue;
                    try {
                        return loader.load(this.classLoader, this.name, url);
                    }
                    catch (ConfigException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }

            @Override
            public Config load(File file) throws ConfigException {
                try {
                    return this.load(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new ConfigException("Failed to load file " + file, e);
                }
            }
        };
    }

    static /* synthetic */ SimpleCascadeStrategy access$000() {
        return DEFAULT_CASCADE_STRATEGY;
    }

    public static class Builder {
        private List<ConfigReader> loaders = new ArrayList<ConfigReader>();
        private CascadeStrategy defaultStrategy = DefaultConfigLoader.access$000();
        private boolean failOnFirst = true;
        private String includeKey = "@next";
        private StrInterpolator interpolator;

        public Builder withConfigReader(ConfigReader loader) {
            this.loaders.add(loader);
            return this;
        }

        public Builder withDefaultCascadingStrategy(CascadeStrategy strategy) {
            if (strategy != null) {
                this.defaultStrategy = strategy;
            }
            return this;
        }

        public Builder withFailOnFirst(boolean flag) {
            this.failOnFirst = flag;
            return this;
        }

        public Builder withStrInterpolator(StrInterpolator interpolator) {
            if (interpolator != null) {
                this.interpolator = interpolator;
            }
            return this;
        }

        public Builder withConfigReader(List<ConfigReader> loaders) {
            if (loaders != null) {
                this.loaders = loaders;
            }
            return this;
        }

        public Builder withIncludeKey(String key) {
            if (key != null) {
                this.includeKey = key;
            }
            return this;
        }

        public DefaultConfigLoader build() {
            return new DefaultConfigLoader(this);
        }
    }
}

