/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.ComparableOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.StringOperation;
import javax.annotation.Nullable;

public abstract class StringExpression
extends ComparableExpression<String> {
    private static final long serialVersionUID = 1536955079961023361L;
    @Nullable
    private volatile NumberExpression<Integer> length;
    @Nullable
    private volatile StringExpression lower;
    @Nullable
    private volatile StringExpression trim;
    @Nullable
    private volatile StringExpression upper;
    @Nullable
    private volatile StringExpression min;
    @Nullable
    private volatile StringExpression max;
    @Nullable
    private volatile BooleanExpression isempty;

    public StringExpression(Expression<String> mixin) {
        super(mixin);
    }

    public StringExpression as(Path<String> alias) {
        return StringOperation.create(Ops.ALIAS, this.mixin, alias);
    }

    @Override
    public StringExpression as(String alias) {
        return this.as((Path)new PathImpl<String>(String.class, alias));
    }

    public StringExpression append(Expression<String> str) {
        return StringOperation.create(Ops.CONCAT, this.mixin, str);
    }

    public StringExpression append(String str) {
        return this.append(ConstantImpl.create(str));
    }

    public SimpleExpression<Character> charAt(Expression<Integer> i) {
        return ComparableOperation.create(Character.class, Ops.CHAR_AT, this.mixin, i);
    }

    public SimpleExpression<Character> charAt(int i) {
        return this.charAt(ConstantImpl.create(i));
    }

    public StringExpression concat(Expression<String> str) {
        return this.append(str);
    }

    public StringExpression concat(String str) {
        return this.append(str);
    }

    public BooleanExpression contains(Expression<String> str) {
        return BooleanOperation.create(Ops.STRING_CONTAINS, this.mixin, str);
    }

    public BooleanExpression contains(String str) {
        return this.contains(ConstantImpl.create(str));
    }

    public BooleanExpression containsIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.STRING_CONTAINS_IC, this.mixin, str);
    }

    public BooleanExpression containsIgnoreCase(String str) {
        return this.containsIgnoreCase(ConstantImpl.create(str));
    }

    public BooleanExpression endsWith(Expression<String> str) {
        return BooleanOperation.create(Ops.ENDS_WITH, this.mixin, str);
    }

    public BooleanExpression endsWithIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.ENDS_WITH_IC, this.mixin, str);
    }

    public BooleanExpression endsWith(String str) {
        return this.endsWith(ConstantImpl.create(str));
    }

    public BooleanExpression endsWithIgnoreCase(String str) {
        return this.endsWithIgnoreCase(ConstantImpl.create(str));
    }

    public BooleanExpression equalsIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.EQ_IGNORE_CASE, this.mixin, str);
    }

    public BooleanExpression equalsIgnoreCase(String str) {
        return this.equalsIgnoreCase(ConstantImpl.create(str));
    }

    public NumberExpression<Integer> indexOf(Expression<String> str) {
        return NumberOperation.create(Integer.class, Ops.INDEX_OF, this.mixin, str);
    }

    public NumberExpression<Integer> indexOf(String str) {
        return this.indexOf(ConstantImpl.create(str));
    }

    public NumberExpression<Integer> indexOf(String str, int i) {
        return this.indexOf(ConstantImpl.create(str), i);
    }

    public NumberExpression<Integer> indexOf(Expression<String> str, int i) {
        return NumberOperation.create(Integer.class, Ops.INDEX_OF_2ARGS, this.mixin, str, ConstantImpl.create(i));
    }

    public BooleanExpression isEmpty() {
        if (this.isempty == null) {
            this.isempty = BooleanOperation.create(Ops.STRING_IS_EMPTY, this.mixin);
        }
        return this.isempty;
    }

    public BooleanExpression isNotEmpty() {
        return this.isEmpty().not();
    }

    public NumberExpression<Integer> length() {
        if (this.length == null) {
            this.length = NumberOperation.create(Integer.class, Ops.STRING_LENGTH, this.mixin);
        }
        return this.length;
    }

    public BooleanExpression like(String str) {
        return BooleanOperation.create(Ops.LIKE, this, ConstantImpl.create(str));
    }

    public BooleanExpression like(Expression<String> str) {
        return BooleanOperation.create(Ops.LIKE, this.mixin, str);
    }

    public BooleanExpression likeIgnoreCase(String str) {
        return BooleanOperation.create(Ops.LIKE_IC, this.mixin, ConstantImpl.create(str));
    }

    public BooleanExpression likeIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.LIKE_IC, this.mixin, str);
    }

    public BooleanExpression like(String str, char escape) {
        return BooleanOperation.create(Ops.LIKE_ESCAPE, this.mixin, ConstantImpl.create(str), ConstantImpl.create(escape));
    }

    public BooleanExpression like(Expression<String> str, char escape) {
        return BooleanOperation.create(Ops.LIKE_ESCAPE, this.mixin, str, ConstantImpl.create(escape));
    }

    public BooleanExpression likeIgnoreCase(String str, char escape) {
        return BooleanOperation.create(Ops.LIKE_ESCAPE_IC, this.mixin, ConstantImpl.create(str), ConstantImpl.create(escape));
    }

    public BooleanExpression likeIgnoreCase(Expression<String> str, char escape) {
        return BooleanOperation.create(Ops.LIKE_ESCAPE_IC, this.mixin, str, ConstantImpl.create(escape));
    }

    public NumberExpression<Integer> locate(Expression<String> str) {
        return NumberOperation.create(Integer.class, Ops.StringOps.LOCATE, str, this.mixin);
    }

    public NumberExpression<Integer> locate(String str) {
        return NumberOperation.create(Integer.class, Ops.StringOps.LOCATE, ConstantImpl.create(str), this.mixin);
    }

    public NumberExpression<Integer> locate(Expression<String> str, NumberExpression<Integer> start) {
        return NumberOperation.create(Integer.class, Ops.StringOps.LOCATE2, str, this.mixin, start);
    }

    public NumberExpression<Integer> locate(String str, int start) {
        return NumberOperation.create(Integer.class, Ops.StringOps.LOCATE2, ConstantImpl.create(str), this.mixin, ConstantImpl.create(start));
    }

    public StringExpression lower() {
        if (this.lower == null) {
            this.lower = StringOperation.create(Ops.LOWER, this.mixin);
        }
        return this.lower;
    }

    public BooleanExpression matches(Expression<String> regex) {
        return BooleanOperation.create(Ops.MATCHES, this.mixin, regex);
    }

    public BooleanExpression matches(String regex) {
        return this.matches(ConstantImpl.create(regex));
    }

    public StringExpression max() {
        if (this.max == null) {
            this.max = StringOperation.create(Ops.AggOps.MAX_AGG, this.mixin);
        }
        return this.max;
    }

    public StringExpression min() {
        if (this.min == null) {
            this.min = StringOperation.create(Ops.AggOps.MIN_AGG, this.mixin);
        }
        return this.min;
    }

    public BooleanExpression notEqualsIgnoreCase(Expression<String> str) {
        return this.equalsIgnoreCase(str).not();
    }

    public BooleanExpression notEqualsIgnoreCase(String str) {
        return this.equalsIgnoreCase(str).not();
    }

    public BooleanExpression notLike(String str) {
        return this.like(str).not();
    }

    public BooleanExpression notLike(Expression<String> str) {
        return this.like(str).not();
    }

    public BooleanExpression notLike(String str, char escape) {
        return this.like(str, escape).not();
    }

    public BooleanExpression notLike(Expression<String> str, char escape) {
        return this.like(str, escape).not();
    }

    public StringExpression prepend(Expression<String> str) {
        return StringOperation.create(Ops.CONCAT, str, this.mixin);
    }

    public StringExpression prepend(String str) {
        return this.prepend(ConstantImpl.create(str));
    }

    public BooleanExpression startsWith(Expression<String> str) {
        return BooleanOperation.create(Ops.STARTS_WITH, this.mixin, str);
    }

    public BooleanExpression startsWithIgnoreCase(Expression<String> str) {
        return BooleanOperation.create(Ops.STARTS_WITH_IC, this.mixin, str);
    }

    public BooleanExpression startsWith(String str) {
        return this.startsWith(ConstantImpl.create(str));
    }

    public BooleanExpression startsWithIgnoreCase(String str) {
        return this.startsWithIgnoreCase(ConstantImpl.create(str));
    }

    @Override
    public StringExpression stringValue() {
        return this;
    }

    public StringExpression substring(int beginIndex) {
        return StringOperation.create(Ops.SUBSTR_1ARG, this.mixin, ConstantImpl.create(beginIndex));
    }

    public StringExpression substring(int beginIndex, int endIndex) {
        return StringOperation.create(Ops.SUBSTR_2ARGS, this.mixin, ConstantImpl.create(beginIndex), ConstantImpl.create(endIndex));
    }

    public StringExpression substring(Expression<Integer> beginIndex, int endIndex) {
        return StringOperation.create(Ops.SUBSTR_2ARGS, this.mixin, beginIndex, ConstantImpl.create(endIndex));
    }

    public StringExpression substring(int beginIndex, Expression<Integer> endIndex) {
        return StringOperation.create(Ops.SUBSTR_2ARGS, this.mixin, ConstantImpl.create(beginIndex), endIndex);
    }

    public StringExpression substring(Expression<Integer> beginIndex) {
        return StringOperation.create(Ops.SUBSTR_1ARG, this.mixin, beginIndex);
    }

    public StringExpression substring(Expression<Integer> beginIndex, Expression<Integer> endIndex) {
        return StringOperation.create(Ops.SUBSTR_2ARGS, this.mixin, beginIndex, endIndex);
    }

    public StringExpression toLowerCase() {
        return this.lower();
    }

    public StringExpression toUpperCase() {
        return this.upper();
    }

    public StringExpression trim() {
        if (this.trim == null) {
            this.trim = StringOperation.create(Ops.TRIM, this.mixin);
        }
        return this.trim;
    }

    public StringExpression upper() {
        if (this.upper == null) {
            this.upper = StringOperation.create(Ops.UPPER, this.mixin);
        }
        return this.upper;
    }
}

