/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntityType;
import com.mysema.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;

public final class TypeFactory {
    private final Map<List<Type>, com.mysema.codegen.model.Type> cache = new HashMap<List<Type>, com.mysema.codegen.model.Type>();
    private final Collection<Class<? extends Annotation>> entityAnnotations;
    private final Set<Class<?>> embeddableTypes = new HashSet();
    private boolean unknownAsEntity;

    public TypeFactory(Class<?> ... entityAnnotations) {
        this(Arrays.asList(entityAnnotations));
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public com.mysema.codegen.model.Type create(Class<?> cl) {
        return this.create(cl, cl);
    }

    public com.mysema.codegen.model.Type create(Class<?> cl, Type genericType) {
        Object value;
        List<Type> key = Arrays.asList(cl, genericType);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        if (cl.isPrimitive()) {
            cl = ClassUtils.primitiveToWrapper(cl);
        }
        boolean entity = false;
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (cl.getAnnotation(clazz) == null) continue;
            entity = true;
            break;
        }
        if (this.embeddableTypes.contains(cl)) {
            entity = true;
        }
        com.mysema.codegen.model.Type[] parameters = this.getParameters(cl, genericType);
        if (cl.isArray()) {
            value = this.create(cl.getComponentType()).asArrayType();
        } else if (cl.isEnum()) {
            value = new ClassType(TypeCategory.ENUM, cl, new com.mysema.codegen.model.Type[0]);
        } else if (Map.class.isAssignableFrom(cl)) {
            value = new SimpleType((com.mysema.codegen.model.Type)Types.MAP, new com.mysema.codegen.model.Type[]{parameters[0], parameters[1]});
        } else if (List.class.isAssignableFrom(cl)) {
            value = new SimpleType((com.mysema.codegen.model.Type)Types.LIST, new com.mysema.codegen.model.Type[]{parameters[0]});
        } else if (Set.class.isAssignableFrom(cl)) {
            value = new SimpleType((com.mysema.codegen.model.Type)Types.SET, new com.mysema.codegen.model.Type[]{parameters[0]});
        } else if (Collection.class.isAssignableFrom(cl)) {
            value = new SimpleType((com.mysema.codegen.model.Type)Types.COLLECTION, new com.mysema.codegen.model.Type[]{parameters[0]});
        } else if (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl)) {
            value = new ClassType(TypeCategory.NUMERIC, cl, parameters);
        } else {
            TypeCategory typeCategory = TypeCategory.get((String)cl.getName());
            if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl)) {
                typeCategory = TypeCategory.COMPARABLE;
            } else if (entity) {
                typeCategory = TypeCategory.ENTITY;
            } else if (this.unknownAsEntity && typeCategory == TypeCategory.SIMPLE && !cl.getName().startsWith("java")) {
                typeCategory = TypeCategory.ENTITY;
            }
            value = new ClassType(typeCategory, cl, parameters);
        }
        if (entity) {
            value = new EntityType((com.mysema.codegen.model.Type)value);
        }
        this.cache.put(key, (com.mysema.codegen.model.Type)value);
        return value;
    }

    private com.mysema.codegen.model.Type[] getParameters(Class<?> cl, Type genericType) {
        int parameterCount = ReflectionUtils.getTypeParameterCount(genericType);
        if (parameterCount > 0) {
            boolean collectionOrMap = Collection.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl);
            return this.getGenericParameters(genericType, collectionOrMap, parameterCount);
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return new com.mysema.codegen.model.Type[]{Types.OBJECT};
        }
        if (Map.class.isAssignableFrom(cl)) {
            return new com.mysema.codegen.model.Type[]{Types.OBJECT, Types.OBJECT};
        }
        if (cl.getTypeParameters().length > 0) {
            return this.getTypeParameters(cl);
        }
        return new com.mysema.codegen.model.Type[0];
    }

    private com.mysema.codegen.model.Type[] getGenericParameters(Type genericType, boolean collectionOrMap, int parameterCount) {
        com.mysema.codegen.model.Type[] types = new com.mysema.codegen.model.Type[parameterCount];
        for (int i = 0; i < types.length; ++i) {
            Type parameter = ((ParameterizedType)genericType).getActualTypeArguments()[i];
            if (parameter instanceof WildcardType && !collectionOrMap) {
                types[i] = null;
                continue;
            }
            types[i] = this.create(ReflectionUtils.getTypeParameter(genericType, i), parameter);
            if (!(parameter instanceof WildcardType)) continue;
            types[i] = new TypeExtends(types[i]);
        }
        return types;
    }

    private com.mysema.codegen.model.Type[] getTypeParameters(Class<?> cl) {
        com.mysema.codegen.model.Type[] types = new com.mysema.codegen.model.Type[cl.getTypeParameters().length];
        for (int i = 0; i < types.length; ++i) {
            TypeVariable<Class<?>> typeVariable = cl.getTypeParameters()[i];
            types[i] = !typeVariable.getGenericDeclaration().equals(cl) ? this.create(typeVariable.getGenericDeclaration(), typeVariable) : new ClassType(cl, new com.mysema.codegen.model.Type[0]);
        }
        return types;
    }

    public void setUnknownAsEntity(boolean unknownAsEntity) {
        this.unknownAsEntity = unknownAsEntity;
    }

    public void addEmbeddableType(Class<?> cl) {
        this.embeddableTypes.add(cl);
    }
}

