/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntitySerializer;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.path.BeanPath;
import com.mysema.query.types.path.BooleanPath;
import com.mysema.query.types.path.ComparablePath;
import com.mysema.query.types.path.DatePath;
import com.mysema.query.types.path.DateTimePath;
import com.mysema.query.types.path.EnumPath;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.SimplePath;
import com.mysema.query.types.path.StringPath;
import com.mysema.query.types.path.TimePath;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Generated;
import javax.inject.Inject;
import javax.inject.Named;

public final class EmbeddableSerializer
extends EntitySerializer {
    @Inject
    public EmbeddableSerializer(TypeMappings typeMappings, @Named(value="keywords") Collection<String> keywords) {
        super(typeMappings, keywords);
    }

    @Override
    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Class pathType;
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        TypeCategory category = model.getOriginalCategory();
        if (model.getProperties().isEmpty()) {
            switch (category) {
                case COMPARABLE: {
                    pathType = ComparablePath.class;
                    break;
                }
                case ENUM: {
                    pathType = EnumPath.class;
                    break;
                }
                case DATE: {
                    pathType = DatePath.class;
                    break;
                }
                case DATETIME: {
                    pathType = DateTimePath.class;
                    break;
                }
                case TIME: {
                    pathType = TimePath.class;
                    break;
                }
                case NUMERIC: {
                    pathType = NumberPath.class;
                    break;
                }
                case STRING: {
                    pathType = StringPath.class;
                    break;
                }
                case BOOLEAN: {
                    pathType = BooleanPath.class;
                    break;
                }
                default: {
                    pathType = BeanPath.class;
                    break;
                }
            }
        } else {
            pathType = BeanPath.class;
        }
        for (Annotation annotation : model.getAnnotations()) {
            writer.annotation(annotation);
        }
        writer.line(new String[]{"@Generated(\"", this.getClass().getName(), "\")"});
        if (category == TypeCategory.BOOLEAN || category == TypeCategory.STRING) {
            writer.beginClass(queryType, (Type)new ClassType(pathType, new Type[0]), new Type[0]);
        } else {
            writer.beginClass(queryType, (Type)new ClassType(category, pathType, new Type[]{model}), new Type[0]);
        }
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()));
    }

    @Override
    protected void introFactoryMethods(CodeWriter writer, EntityType model) throws IOException {
    }

    @Override
    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        writer.staticimports(new Class[]{PathMetadataFactory.class});
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        if (!(model.getPackageName().isEmpty() || queryType.getPackageName().equals(model.getPackageName()) || queryType.getSimpleName().equals(model.getSimpleName()))) {
            String packageName;
            String fullName = model.getFullName();
            if (fullName.substring((packageName = model.getPackageName()).length() + 1).contains(".")) {
                fullName = fullName.substring(0, fullName.lastIndexOf(46));
            }
            writer.importClasses(new String[]{fullName});
        }
        this.introDelegatePackages(writer, model);
        ArrayList<Package> packages = new ArrayList<Package>();
        packages.add(PathMetadata.class.getPackage());
        packages.add(SimplePath.class.getPackage());
        if (this.isImportExprPackage(model)) {
            packages.add(ComparableExpression.class.getPackage());
        }
        writer.imports(packages.toArray(new Package[packages.size()]));
        writer.imports(new Class[]{Generated.class});
    }
}

