/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.alias;

import com.mysema.commons.lang.Pair;
import com.mysema.query.alias.ManagedObject;
import com.mysema.query.alias.PathFactory;
import com.mysema.query.alias.PropertyAccessInvocationHandler;
import com.mysema.query.alias.TypeSystem;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.PathMetadataFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

public class AliasFactory {
    private final ThreadLocal<Expression<?>> current = new ThreadLocal();
    private final PathFactory pathFactory;
    private final TypeSystem typeSystem;
    private final Map<Pair<Class<?>, String>, EntityPath<?>> pathCache;
    private final Map<Pair<Class<?>, Expression<?>>, ManagedObject> proxyCache = LazyMap.decorate(new HashMap(), (Transformer)new Transformer<Pair<Class<?>, Expression<?>>, ManagedObject>(){

        public ManagedObject transform(Pair<Class<?>, Expression<?>> input) {
            return (ManagedObject)AliasFactory.this.createProxy((Class)input.getFirst(), (Expression)input.getSecond());
        }
    });

    public AliasFactory(final PathFactory pathFactory, TypeSystem typeSystem) {
        this.pathFactory = pathFactory;
        this.typeSystem = typeSystem;
        this.pathCache = LazyMap.decorate(new HashMap(), (Transformer)new Transformer<Pair<Class<?>, String>, EntityPath<?>>(){

            public EntityPath<?> transform(Pair<Class<?>, String> input) {
                return (EntityPath)pathFactory.createEntityPath((Class)input.getFirst(), PathMetadataFactory.forVariable((String)input.getSecond()));
            }
        });
    }

    public <A> A createAliasForExpr(Class<A> cl, Expression<? extends A> expr) {
        return (A)this.proxyCache.get(Pair.of(cl, expr));
    }

    public <A> A createAliasForProperty(Class<A> cl, Object parent, Expression<?> path) {
        return this.createProxy(cl, path);
    }

    public <A> A createAliasForVariable(Class<A> cl, String var) {
        Expression path = this.pathCache.get(Pair.of(cl, (Object)var));
        return (A)this.proxyCache.get(Pair.of(cl, (Object)path));
    }

    protected <A> A createProxy(Class<A> cl, Expression<?> path) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(AliasFactory.class.getClassLoader());
        if (cl.isInterface()) {
            enhancer.setInterfaces(new Class[]{cl, ManagedObject.class});
        } else {
            enhancer.setSuperclass(cl);
            enhancer.setInterfaces(new Class[]{ManagedObject.class});
        }
        PropertyAccessInvocationHandler handler = new PropertyAccessInvocationHandler(path, this, this.pathFactory, this.typeSystem);
        enhancer.setCallback((Callback)handler);
        return (A)enhancer.create();
    }

    @Nullable
    public <A extends Expression<?>> A getCurrent() {
        return (A)this.current.get();
    }

    @Nullable
    public <A extends Expression<?>> A getCurrentAndReset() {
        A rv = this.getCurrent();
        this.reset();
        return rv;
    }

    public void reset() {
        this.current.set(null);
    }

    public void setCurrent(Expression<?> expr) {
        this.current.set(expr);
    }
}

