/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.mysema.query.Projectable;
import com.mysema.query.ResultTransformer;
import com.mysema.query.group.GroupBy;
import com.mysema.query.group.GroupColumnDefinition;
import com.mysema.query.group.GroupProcessor;
import com.mysema.query.group.GroupProcessorFactory;
import java.util.List;

public class ProcessorGroupBy<K, O>
implements ResultTransformer<O> {
    private final GroupBy<K> groupBy;
    private final GroupProcessorFactory<K, O> processorFactory;

    public static <K, O> ProcessorGroupBy<K, O> create(GroupBy<K> groupBy, GroupProcessor<K, O> processor) {
        return new ProcessorGroupBy<K, O>(groupBy, processor);
    }

    public static <K, O> ProcessorGroupBy<K, O> create(GroupBy<K> groupBy, GroupProcessorFactory<K, O> processorFactory) {
        return new ProcessorGroupBy<K, O>(groupBy, processorFactory);
    }

    public ProcessorGroupBy(GroupBy<K> groupBy, final GroupProcessor<K, O> processor) {
        this(groupBy, new GroupProcessorFactory<K, O>(){

            @Override
            public GroupProcessor<K, O> createProcessor(List<GroupColumnDefinition<?, ?>> columnDefinitions) {
                return processor;
            }
        });
    }

    public ProcessorGroupBy(GroupBy<K> groupBy, GroupProcessorFactory<K, O> processorFactory) {
        this.groupBy = groupBy;
        this.processorFactory = processorFactory;
    }

    @Override
    public O transform(Projectable projectable) {
        return this.groupBy.process(projectable, this.processorFactory.createProcessor(this.groupBy.getColumnDefinitions()));
    }
}

