/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.EnumExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.TimeExpression;
import com.mysema.query.types.path.ArrayPath;
import com.mysema.query.types.path.BooleanPath;
import com.mysema.query.types.path.ComparablePath;
import com.mysema.query.types.path.DatePath;
import com.mysema.query.types.path.DateTimePath;
import com.mysema.query.types.path.EnumPath;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.SimplePath;
import com.mysema.query.types.path.StringPath;
import com.mysema.query.types.path.TimePath;
import com.mysema.query.types.template.BooleanTemplate;
import com.mysema.query.types.template.ComparableTemplate;
import com.mysema.query.types.template.DateTemplate;
import com.mysema.query.types.template.DateTimeTemplate;
import com.mysema.query.types.template.EnumTemplate;
import com.mysema.query.types.template.NumberTemplate;
import com.mysema.query.types.template.SimpleTemplate;
import com.mysema.query.types.template.StringTemplate;
import com.mysema.query.types.template.TimeTemplate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class TypeMappings {
    private final Map<String, Type> queryTypes = new HashMap<String, Type>();
    private final Map<TypeCategory, Type> exprTypes = new HashMap<TypeCategory, Type>();
    private final Map<TypeCategory, Type> pathTypes = new HashMap<TypeCategory, Type>();
    private final Map<TypeCategory, Type> templateTypes = new HashMap<TypeCategory, Type>();

    public TypeMappings() {
        this.register(TypeCategory.STRING, StringExpression.class, StringPath.class, StringTemplate.class);
        this.register(TypeCategory.BOOLEAN, BooleanExpression.class, BooleanPath.class, BooleanTemplate.class);
        this.register(TypeCategory.COMPARABLE, ComparableExpression.class, ComparablePath.class, ComparableTemplate.class);
        this.register(TypeCategory.ENUM, EnumExpression.class, EnumPath.class, EnumTemplate.class);
        this.register(TypeCategory.DATE, DateExpression.class, DatePath.class, DateTemplate.class);
        this.register(TypeCategory.DATETIME, DateTimeExpression.class, DateTimePath.class, DateTimeTemplate.class);
        this.register(TypeCategory.TIME, TimeExpression.class, TimePath.class, TimeTemplate.class);
        this.register(TypeCategory.NUMERIC, NumberExpression.class, NumberPath.class, NumberTemplate.class);
        this.register(TypeCategory.SIMPLE, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.ARRAY, Expression.class, ArrayPath.class, SimpleTemplate.class);
        this.register(TypeCategory.COLLECTION, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.SET, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.LIST, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.MAP, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.CUSTOM, Expression.class, Path.class, SimpleTemplate.class);
        this.register(TypeCategory.ENTITY, Expression.class, Path.class, SimpleTemplate.class);
    }

    public Type getTemplateType(Type type, EntityType model, boolean raw) {
        return this.getTemplateType(type, model, raw, false, false);
    }

    public Type getTemplateType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.templateTypes, type, model, raw, rawParameters, extend);
    }

    public Type getExprType(Type type, EntityType model, boolean raw) {
        return this.getExprType(type, model, raw, false, false);
    }

    public Type getExprType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        if (this.queryTypes.containsKey(type.getFullName())) {
            return this.queryTypes.get(type.getFullName());
        }
        return this.getQueryType(this.exprTypes, type, model, raw, rawParameters, extend);
    }

    public Type getPathType(Type type, EntityType model, boolean raw) {
        return this.getPathType(type, model, raw, false, false);
    }

    public Type getPathType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        if (this.queryTypes.containsKey(type.getFullName())) {
            return this.queryTypes.get(type.getFullName());
        }
        return this.getQueryType(this.pathTypes, type, model, raw, rawParameters, extend);
    }

    private Type getQueryType(Map<TypeCategory, Type> types, Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        Type exprType = types.get(type.getCategory());
        return this.getQueryType(type, model, exprType, raw, rawParameters, extend);
    }

    public Type getQueryType(Type type, EntityType model, Type exprType, boolean raw, boolean rawParameters, boolean extend) {
        TypeCategory category = type.getCategory();
        if (raw && category != TypeCategory.ENTITY && category != TypeCategory.CUSTOM) {
            return exprType;
        }
        if (category == TypeCategory.STRING || category == TypeCategory.BOOLEAN) {
            return exprType;
        }
        if (rawParameters) {
            type = new SimpleType(type, new Type[0]);
        }
        if (!type.isFinal() && extend) {
            type = new TypeExtends(type);
        }
        return new SimpleType(exprType, new Type[]{type});
    }

    public void register(TypeCategory category, @Nullable Class<? extends Expression> expr, @Nullable Class<? extends Path> path, @Nullable Class<? extends TemplateExpression> template) {
        if (expr != null) {
            this.exprTypes.put(category, (Type)new ClassType(expr, new Type[0]));
        }
        if (path != null) {
            this.pathTypes.put(category, (Type)new ClassType(path, new Type[0]));
        }
        if (template != null) {
            this.templateTypes.put(category, (Type)new ClassType(template, new Type[0]));
        }
    }

    public void register(Type type, Type queryType) {
        this.queryTypes.put(type.getFullName(), queryType);
    }

    public boolean isRegistered(Type type) {
        return this.queryTypes.containsKey(type.getFullName());
    }
}

