/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.commons.lang.Assert;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.ListExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.path.CollectionPathBase;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ListPath<E, Q extends SimpleExpression<E>>
extends CollectionPathBase<List<E>, E>
implements ListExpression<E> {
    private static final long serialVersionUID = 3302301599074388860L;
    private final Map<Integer, Q> cache = new HashMap<Integer, Q>();
    private final Class<E> elementType;
    private final Path<List<E>> pathMixin;
    private final Class<Q> queryType;
    @Nullable
    private transient Q any;

    public ListPath(Class<? super E> elementType, Class<Q> queryType, String variable) {
        this(elementType, queryType, PathMetadataFactory.forVariable(variable));
    }

    public ListPath(Class<? super E> elementType, Class<Q> queryType, PathMetadata<?> metadata) {
        super(List.class);
        this.elementType = (Class)Assert.notNull(elementType, (String)"type");
        this.queryType = queryType;
        this.pathMixin = new PathImpl<List>(List.class, metadata);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public Q any() {
        if (this.any == null) {
            try {
                this.any = this.newInstance(this.queryType, this.pathMixin.getMetadata());
            }
            catch (NoSuchMethodException e) {
                throw new ExpressionException(e);
            }
            catch (InstantiationException e) {
                throw new ExpressionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ExpressionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ExpressionException(e);
            }
        }
        return this.any;
    }

    protected PathMetadata<Integer> forListAccess(int index) {
        return PathMetadataFactory.forListAccess(this, index);
    }

    protected PathMetadata<Integer> forListAccess(Expression<Integer> index) {
        return PathMetadataFactory.forListAccess(this, index);
    }

    private Q create(int index) {
        try {
            PathMetadata<Integer> md = this.forListAccess(index);
            return this.newInstance(this.queryType, md);
        }
        catch (NoSuchMethodException e) {
            throw new ExpressionException(e);
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.pathMixin.equals(o);
    }

    public Q get(Expression<Integer> index) {
        try {
            PathMetadata<Integer> md = this.forListAccess(index);
            return this.newInstance(this.queryType, md);
        }
        catch (NoSuchMethodException e) {
            throw new ExpressionException(e);
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionException(e);
        }
    }

    public Q get(int index) {
        if (this.cache.containsKey(index)) {
            return (Q)((SimpleExpression)this.cache.get(index));
        }
        Q rv = this.create(index);
        this.cache.put(index, rv);
        return rv;
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public int hashCode() {
        return this.pathMixin.hashCode();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }

    @Override
    public Class<?> getParameter(int index) {
        if (index == 0) {
            return this.elementType;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }
}

