/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.path;

import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.BooleanOperation;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.path.ArrayPath;
import com.mysema.query.types.path.BooleanPath;
import com.mysema.query.types.path.CollectionPath;
import com.mysema.query.types.path.ComparablePath;
import com.mysema.query.types.path.DatePath;
import com.mysema.query.types.path.DateTimePath;
import com.mysema.query.types.path.EnumPath;
import com.mysema.query.types.path.ListPath;
import com.mysema.query.types.path.MapPath;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.PathInits;
import com.mysema.query.types.path.SetPath;
import com.mysema.query.types.path.SimplePath;
import com.mysema.query.types.path.StringPath;
import com.mysema.query.types.path.TimePath;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class BeanPath<D>
extends SimpleExpression<D>
implements Path<D> {
    private static final long serialVersionUID = -1845524024957822731L;
    private final Map<Class<?>, Object> casts = new HashMap();
    @Nullable
    private final PathInits inits;
    private final Path<D> pathMixin;

    public BeanPath(Class<? extends D> type, String variable) {
        this(type, PathMetadataFactory.forVariable(variable), null);
    }

    public BeanPath(Class<? extends D> type, PathMetadata<?> metadata) {
        this(type, metadata, null);
    }

    public BeanPath(Class<? extends D> type, PathMetadata<?> metadata, @Nullable PathInits inits) {
        super(type);
        this.pathMixin = new PathImpl<D>(type, metadata);
        this.inits = inits;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public <T extends BeanPath<? extends D>> T as(Class<T> clazz) {
        try {
            if (!this.casts.containsKey(clazz)) {
                BeanPath rv = this.inits != null ? (BeanPath)clazz.getConstructor(PathMetadata.class, PathInits.class).newInstance(this.getMetadata(), this.inits) : (BeanPath)clazz.getConstructor(PathMetadata.class).newInstance(this.getMetadata());
                this.casts.put(clazz, rv);
                return (T)rv;
            }
            return (T)((BeanPath)this.casts.get(clazz));
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }

    protected <P extends Path<?>> P add(P path) {
        return path;
    }

    protected <A> ArrayPath<A> createArray(String property, Class<? super A[]> type) {
        return this.add(new ArrayPath(type, this.forProperty(property)));
    }

    protected BooleanPath createBoolean(String property) {
        return this.add(new BooleanPath(this.forProperty(property)));
    }

    protected <A, E extends SimpleExpression<A>> CollectionPath<A, E> createCollection(String property, Class<? super A> type, Class<? super E> queryType) {
        return this.add(new CollectionPath<A, E>(type, queryType, this.forProperty(property)));
    }

    protected <A extends Comparable> ComparablePath<A> createComparable(String property, Class<? super A> type) {
        return this.add(new ComparablePath<A>(type, this.forProperty(property)));
    }

    protected <A extends Enum<A>> EnumPath<A> createEnum(String property, Class<A> type) {
        return this.add(new EnumPath<A>(type, this.forProperty(property)));
    }

    protected <A extends Comparable> DatePath<A> createDate(String property, Class<? super A> type) {
        return this.add(new DatePath<A>(type, this.forProperty(property)));
    }

    protected <A extends Comparable> DateTimePath<A> createDateTime(String property, Class<? super A> type) {
        return this.add(new DateTimePath<A>(type, this.forProperty(property)));
    }

    protected <A, E extends SimpleExpression<A>> ListPath<A, E> createList(String property, Class<? super A> type, Class<? super E> queryType) {
        return this.add(new ListPath<A, E>(type, queryType, this.forProperty(property)));
    }

    protected <K, V, E extends SimpleExpression<V>> MapPath<K, V, E> createMap(String property, Class<? super K> key, Class<? super V> value, Class<? super E> queryType) {
        return this.add(new MapPath<K, V, E>(key, value, queryType, this.forProperty(property)));
    }

    protected <A extends Number> NumberPath<A> createNumber(String property, Class<? super A> type) {
        return this.add(new NumberPath<A>(type, this.forProperty(property)));
    }

    protected <A, E extends SimpleExpression<A>> SetPath<A, E> createSet(String property, Class<? super A> type, Class<? super E> queryType) {
        return this.add(new SetPath<A, E>(type, queryType, this.forProperty(property)));
    }

    protected <A> SimplePath<A> createSimple(String property, Class<? super A> type) {
        return this.add(new SimplePath<A>(type, this.forProperty(property)));
    }

    protected StringPath createString(String property) {
        return this.add(new StringPath(this.forProperty(property)));
    }

    protected <A extends Comparable> TimePath<A> createTime(String property, Class<? super A> type) {
        return this.add(new TimePath<A>(type, this.forProperty(property)));
    }

    @Override
    public boolean equals(Object o) {
        return this.pathMixin.equals(o);
    }

    protected PathMetadata<?> forProperty(String property) {
        return PathMetadataFactory.forProperty(this, property);
    }

    @Override
    public PathMetadata<?> getMetadata() {
        return this.pathMixin.getMetadata();
    }

    @Override
    public Path<?> getRoot() {
        return this.pathMixin.getRoot();
    }

    @Override
    public int hashCode() {
        return this.pathMixin.hashCode();
    }

    public <B extends D> BooleanExpression instanceOf(Class<B> type) {
        return BooleanOperation.create(Ops.INSTANCE_OF, this, new ConstantImpl<Class<B>>(type));
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.pathMixin.getAnnotatedElement();
    }
}

