/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.util.StringEscape;
import org.apache.commons.collections15.Transformer;

public final class Converters {
    public static final Transformer<Expression<String>, Expression<String>> toLowerCase = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(arg.toString().toLowerCase());
            }
            return new OperationImpl<String>(String.class, Ops.LOWER, arg);
        }
    };
    public static final Transformer<Expression<String>, Expression<String>> toUpperCase = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(arg.toString().toUpperCase());
            }
            return new OperationImpl<String>(String.class, Ops.UPPER, arg);
        }
    };
    public static final Transformer<Expression<String>, Expression<String>> toStartsWithViaLike = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(StringEscape.escapeForLike((Constant)arg) + "%");
            }
            return new OperationImpl<String>(String.class, Ops.CONCAT, arg, ConstantImpl.create("%"));
        }
    };
    public static final Transformer<Expression<String>, Expression<String>> toStartsWithViaLikeLower = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create(StringEscape.escapeForLike((Constant)arg).toLowerCase() + "%");
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, arg, ConstantImpl.create("%"));
            return new OperationImpl<String>(String.class, Ops.LOWER, concated);
        }
    };
    public static final Transformer<Expression<String>, Expression<String>> toEndsWithViaLike = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + StringEscape.escapeForLike((Constant)arg));
            }
            return new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
        }
    };
    public static final Transformer<Expression<String>, Expression<String>> toEndsWithViaLikeLower = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + StringEscape.escapeForLike((Constant)arg).toLowerCase());
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
            return new OperationImpl<String>(String.class, Ops.LOWER, concated);
        }
    };
    public static final Transformer<Expression<String>, Expression<String>> toContainsViaLike = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + StringEscape.escapeForLike((Constant)arg) + "%");
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
            return new OperationImpl<String>(String.class, Ops.CONCAT, concated, ConstantImpl.create("%"));
        }
    };
    public static final Transformer<Expression<String>, Expression<String>> toContainsViaLikeLower = new Transformer<Expression<String>, Expression<String>>(){

        public Expression<String> transform(Expression<String> arg) {
            if (arg instanceof Constant) {
                return ConstantImpl.create("%" + StringEscape.escapeForLike((Constant)arg).toLowerCase() + "%");
            }
            OperationImpl<String> concated = new OperationImpl<String>(String.class, Ops.CONCAT, ConstantImpl.create("%"), arg);
            concated = new OperationImpl<String>(String.class, Ops.CONCAT, concated, ConstantImpl.create("%"));
            return new OperationImpl<String>(String.class, Ops.LOWER, concated);
        }
    };

    private Converters() {
    }
}

