/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.expr.ComparableExpression;
import com.mysema.query.types.expr.DateExpression;
import com.mysema.query.types.expr.DateTimeExpression;
import com.mysema.query.types.expr.EnumExpression;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.StringExpression;
import com.mysema.query.types.expr.TimeExpression;
import com.mysema.query.types.path.BooleanPath;
import com.mysema.query.types.path.ComparablePath;
import com.mysema.query.types.path.DatePath;
import com.mysema.query.types.path.DateTimePath;
import com.mysema.query.types.path.EnumPath;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.SimplePath;
import com.mysema.query.types.path.StringPath;
import com.mysema.query.types.path.TimePath;
import com.mysema.query.types.template.BooleanTemplate;
import com.mysema.query.types.template.ComparableTemplate;
import com.mysema.query.types.template.DateTemplate;
import com.mysema.query.types.template.DateTimeTemplate;
import com.mysema.query.types.template.EnumTemplate;
import com.mysema.query.types.template.NumberTemplate;
import com.mysema.query.types.template.SimpleTemplate;
import com.mysema.query.types.template.StringTemplate;
import com.mysema.query.types.template.TimeTemplate;
import java.util.HashMap;
import java.util.Map;

public final class TypeMappings {
    private final Map<TypeCategory, ClassType> customTypes = new HashMap<TypeCategory, ClassType>();
    private final Map<TypeCategory, ClassType> exprTypes = new HashMap<TypeCategory, ClassType>();
    private final Map<TypeCategory, ClassType> pathTypes = new HashMap<TypeCategory, ClassType>();

    public TypeMappings() {
        this.register(TypeCategory.STRING, StringExpression.class, StringPath.class, StringTemplate.class);
        this.register(TypeCategory.BOOLEAN, BooleanExpression.class, BooleanPath.class, BooleanTemplate.class);
        this.register(TypeCategory.COMPARABLE, ComparableExpression.class, ComparablePath.class, ComparableTemplate.class);
        this.register(TypeCategory.ENUM, EnumExpression.class, EnumPath.class, EnumTemplate.class);
        this.register(TypeCategory.DATE, DateExpression.class, DatePath.class, DateTemplate.class);
        this.register(TypeCategory.DATETIME, DateTimeExpression.class, DateTimePath.class, DateTimeTemplate.class);
        this.register(TypeCategory.TIME, TimeExpression.class, TimePath.class, TimeTemplate.class);
        this.register(TypeCategory.NUMERIC, NumberExpression.class, NumberPath.class, NumberTemplate.class);
        this.register(TypeCategory.ARRAY, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.COLLECTION, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.SET, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.LIST, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.MAP, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.SIMPLE, Expression.class, SimplePath.class, SimpleTemplate.class);
        this.register(TypeCategory.CUSTOM, Expression.class, Path.class, SimpleTemplate.class);
        this.register(TypeCategory.ENTITY, Expression.class, Path.class, SimpleTemplate.class);
    }

    public Type getCustomType(Type type, EntityType model, boolean raw) {
        return this.getCustomType(type, model, raw, false, false);
    }

    public Type getCustomType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.customTypes, type, model, raw, rawParameters, extend);
    }

    public Type getExprType(Type type, EntityType model, boolean raw) {
        return this.getExprType(type, model, raw, false, false);
    }

    public Type getExprType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.exprTypes, type, model, raw, rawParameters, extend);
    }

    public Type getPathType(Type type, EntityType model, boolean raw) {
        return this.getPathType(type, model, raw, false, false);
    }

    public Type getPathType(Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        return this.getQueryType(this.pathTypes, type, model, raw, rawParameters, extend);
    }

    private Type getQueryType(Map<TypeCategory, ClassType> types, Type type, EntityType model, boolean raw, boolean rawParameters, boolean extend) {
        Type exprType = (Type)types.get(type.getCategory());
        return this.getQueryType(type, model, exprType, raw, rawParameters, extend);
    }

    public Type getQueryType(Type type, EntityType model, Type exprType, boolean raw, boolean rawParameters, boolean extend) {
        TypeCategory category = type.getCategory();
        if (raw && category != TypeCategory.ENTITY && category != TypeCategory.CUSTOM) {
            return exprType;
        }
        if (category == TypeCategory.STRING || category == TypeCategory.BOOLEAN) {
            return exprType;
        }
        if (category == TypeCategory.ENTITY || category == TypeCategory.CUSTOM) {
            String packageName = type.getPackageName();
            if (type.getPackageName().isEmpty()) {
                String simpleName = model.getPrefix() + type.getFullName().replace('.', '_');
                return new SimpleType(category, simpleName, "", simpleName, false, false, new Type[0]);
            }
            String simpleName = model.getPrefix() + type.getFullName().substring(packageName.length() + 1).replace('.', '_');
            return new SimpleType(category, packageName + "." + simpleName, packageName, simpleName, false, false, new Type[0]);
        }
        if (rawParameters) {
            type = new SimpleType(type, new Type[0]);
        }
        if (!type.isFinal() && extend) {
            type = new TypeExtends(type);
        }
        return new SimpleType(exprType, new Type[]{type});
    }

    public void register(TypeCategory category, Class<? extends Expression> expr, Class<? extends Path> path, Class<? extends TemplateExpression> custom) {
        this.exprTypes.put(category, new ClassType(expr, new Type[0]));
        this.pathTypes.put(category, new ClassType(path, new Type[0]));
        this.customTypes.put(category, new ClassType(custom, new Type[0]));
    }
}

