/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.TypeSuper;
import com.mysema.codegen.model.Types;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.TypeArgumentsException;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

public final class APTTypeFactory {
    private final Map<List<String>, Type> cache = new HashMap<List<String>, Type>();
    private final Configuration configuration;
    private final Type defaultValue;
    private final List<Class<? extends Annotation>> entityAnnotations;
    private final Map<List<String>, EntityType> entityTypeCache = new HashMap<List<String>, EntityType>();
    private final ProcessingEnvironment env;
    private final TypeElement numberType;
    private final TypeElement comparableType;
    private boolean doubleIndexEntities = true;

    @Nullable
    private static Class<?> safeClassForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public APTTypeFactory(ProcessingEnvironment env, Configuration configuration, TypeFactory factory, List<Class<? extends Annotation>> annotations) {
        this.env = env;
        this.configuration = configuration;
        this.defaultValue = factory.create(Object.class);
        this.entityAnnotations = annotations;
        this.numberType = env.getElementUtils().getTypeElement(Number.class.getName());
        this.comparableType = env.getElementUtils().getTypeElement(Comparable.class.getName());
    }

    private void appendToKey(List<String> key, DeclaredType t, boolean deep) {
        for (TypeMirror typeMirror : t.getTypeArguments()) {
            if (deep) {
                key.addAll(this.createKey(typeMirror, false));
                continue;
            }
            key.add(((Object)typeMirror).toString());
        }
    }

    private void appendToKey(List<String> key, TypeVariable t) {
        if (t.getUpperBound() != null) {
            key.addAll(this.createKey(t.getUpperBound(), false));
        }
        if (t.getLowerBound() != null) {
            key.addAll(this.createKey(t.getLowerBound(), false));
        }
    }

    private void appendToKey(List<String> key, WildcardType t) {
        if (t.getExtendsBound() != null) {
            key.addAll(this.createKey(t.getExtendsBound(), false));
        }
        if (t.getSuperBound() != null) {
            key.addAll(this.createKey(t.getSuperBound(), false));
        }
    }

    private Type create(TypeElement typeElement, TypeCategory category, List<? extends TypeMirror> typeArgs) {
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        String packageName = this.env.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
        Type[] params = new Type[typeArgs.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.create(typeArgs.get(i));
        }
        return new SimpleType(category, name, packageName, simpleName, false, typeElement.getModifiers().contains((Object)Modifier.FINAL), params);
    }

    @Nullable
    public Type create(TypeMirror type) {
        List<String> key = this.createKey(type, true);
        if (this.entityTypeCache.containsKey(key)) {
            return (Type)this.entityTypeCache.get(key);
        }
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        this.cache.put(key, null);
        Type typeModel = this.handle(type);
        if (typeModel != null && typeModel.getCategory() == TypeCategory.ENTITY) {
            EntityType entityType = this.createEntityType(type);
            this.cache.put(key, (Type)entityType);
            return entityType;
        }
        this.cache.put(key, typeModel);
        return typeModel;
    }

    private Type createClassType(DeclaredType t, TypeElement typeElement) {
        String name = typeElement.getQualifiedName().toString();
        TypeCategory typeCategory = TypeCategory.get((String)name);
        if (typeCategory != TypeCategory.NUMERIC && this.isImplemented(typeElement, this.comparableType) && this.isSubType(typeElement, this.numberType)) {
            typeCategory = TypeCategory.NUMERIC;
        } else if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && this.isImplemented(typeElement, this.comparableType)) {
            typeCategory = TypeCategory.COMPARABLE;
        }
        if (typeCategory == TypeCategory.SIMPLE) {
            for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
                if (typeElement.getAnnotation(entityAnn) == null) continue;
                typeCategory = TypeCategory.ENTITY;
            }
        }
        Type type = this.create(typeElement, typeCategory, t.getTypeArguments());
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return new EntityType(this.configuration.getNamePrefix(), type);
        }
        return type;
    }

    private Type createCollectionType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return new SimpleType((Type)Types.COLLECTION, new Type[]{this.create(i.next())});
    }

    @Nullable
    public EntityType createEntityType(TypeMirror type) {
        List<String> key = this.createKey(type, true);
        if (this.entityTypeCache.containsKey(key)) {
            return this.entityTypeCache.get(key);
        }
        this.entityTypeCache.put(key, null);
        Type value = this.handle(type);
        if (value != null) {
            EntityType entityModel = null;
            entityModel = value instanceof EntityType ? (EntityType)value : new EntityType(this.configuration.getNamePrefix(), value);
            this.entityTypeCache.put(key, entityModel);
            if (key.size() > 1 && key.get(0).equals(entityModel.getFullName()) && this.doubleIndexEntities) {
                ArrayList<String> newKey = new ArrayList<String>();
                newKey.add(entityModel.getFullName());
                for (int i = 0; i < entityModel.getParameters().size(); ++i) {
                    newKey.add("?");
                }
                if (!this.entityTypeCache.containsKey(newKey)) {
                    this.entityTypeCache.put(newKey, entityModel);
                }
            }
            for (Type superType : this.getSupertypes(type, value)) {
                entityModel.addSupertype(new Supertype(superType));
            }
            return entityModel;
        }
        return null;
    }

    private Type createEnumType(DeclaredType t, TypeElement typeElement) {
        Type enumType = this.create(typeElement, TypeCategory.ENUM, t.getTypeArguments());
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return new EntityType(this.configuration.getNamePrefix(), enumType);
        }
        return enumType;
    }

    private Type createInterfaceType(DeclaredType t, TypeElement typeElement) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.create(typeElement, TypeCategory.ENTITY, t.getTypeArguments());
        }
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        Iterator<? extends TypeMirror> i = t.getTypeArguments().iterator();
        Class<?> cl = APTTypeFactory.safeClassForName(name);
        if (cl == null) {
            return this.create(typeElement, TypeCategory.get((String)name), t.getTypeArguments());
        }
        if (Map.class.isAssignableFrom(cl)) {
            return this.createMapType(simpleName, i);
        }
        if (List.class.isAssignableFrom(cl)) {
            return this.createListType(simpleName, i);
        }
        if (Set.class.isAssignableFrom(cl)) {
            return this.createSetType(simpleName, i);
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return this.createCollectionType(simpleName, i);
        }
        return this.create(typeElement, TypeCategory.get((String)name), t.getTypeArguments());
    }

    private List<String> createKey(TypeMirror type, boolean deep) {
        ArrayList<String> key = new ArrayList<String>();
        String name = ((Object)type).toString();
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf(60));
        }
        key.add(name);
        if (type.getKind() == TypeKind.TYPEVAR) {
            this.appendToKey(key, (TypeVariable)type);
        } else if (type.getKind() == TypeKind.WILDCARD) {
            this.appendToKey(key, (WildcardType)type);
        } else if (type.getKind() == TypeKind.DECLARED) {
            this.appendToKey(key, (DeclaredType)type, deep);
        }
        return key;
    }

    private Type createListType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return new SimpleType((Type)Types.LIST, new Type[]{this.create(i.next())});
    }

    private Type createMapType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return new SimpleType((Type)Types.MAP, new Type[]{this.create(i.next()), this.create(i.next())});
    }

    private Type createSetType(String simpleName, Iterator<? extends TypeMirror> i) {
        if (!i.hasNext()) {
            throw new TypeArgumentsException(simpleName);
        }
        return new SimpleType((Type)Types.SET, new Type[]{this.create(i.next())});
    }

    private Set<Type> getSupertypes(TypeMirror type, Type value) {
        boolean doubleIndex = this.doubleIndexEntities;
        this.doubleIndexEntities = false;
        Set<Type> superTypes = Collections.emptySet();
        if ((type = this.normalize(type)).getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement e = (TypeElement)declaredType.asElement();
            if (e.getKind() == ElementKind.CLASS) {
                TypeMirror supertype;
                Type type2;
                if (e.getSuperclass().getKind() != TypeKind.NONE && !(type2 = this.create(supertype = this.normalize(e.getSuperclass()))).getFullName().startsWith("java")) {
                    superTypes = Collections.singleton(this.create(supertype));
                }
            } else {
                superTypes = new HashSet(e.getInterfaces().size());
                for (TypeMirror typeMirror : e.getInterfaces()) {
                    Type iface = this.create(typeMirror);
                    if (iface.getFullName().startsWith("java")) continue;
                    superTypes.add(iface);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported type kind " + (Object)((Object)type.getKind()));
        }
        this.doubleIndexEntities = doubleIndex;
        return superTypes;
    }

    @Nullable
    private Type handle(TypeMirror type) {
        if (type instanceof DeclaredType) {
            return this.handleDeclaredType((DeclaredType)type);
        }
        if (type instanceof TypeVariable) {
            return this.handleTypeVariable((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return this.handleWildcard((WildcardType)type);
        }
        if (type instanceof ArrayType) {
            ArrayType t = (ArrayType)type;
            return this.create(t.getComponentType()).asArrayType();
        }
        if (type instanceof PrimitiveType) {
            return this.handlePrimitiveType((PrimitiveType)type);
        }
        if (type instanceof NoType) {
            return this.defaultValue;
        }
        return null;
    }

    private Type handleDeclaredType(DeclaredType t) {
        if (t.asElement() instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)t.asElement();
            switch (typeElement.getKind()) {
                case ENUM: {
                    return this.createEnumType(t, typeElement);
                }
                case CLASS: {
                    return this.createClassType(t, typeElement);
                }
                case INTERFACE: {
                    return this.createInterfaceType(t, typeElement);
                }
            }
            throw new IllegalArgumentException("Illegal type " + typeElement);
        }
        throw new IllegalArgumentException("Unsupported element type " + t.asElement());
    }

    private Type handlePrimitiveType(PrimitiveType t) {
        switch (t.getKind()) {
            case BOOLEAN: {
                return Types.BOOLEAN;
            }
            case BYTE: {
                return Types.BYTE;
            }
            case CHAR: {
                return Types.CHARACTER;
            }
            case DOUBLE: {
                return Types.DOUBLE;
            }
            case FLOAT: {
                return Types.FLOAT;
            }
            case INT: {
                return Types.INTEGER;
            }
            case LONG: {
                return Types.LONG;
            }
            case SHORT: {
                return Types.SHORT;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)t.getKind()));
    }

    @Nullable
    private Type handleTypeVariable(TypeVariable t) {
        String varName = t.toString();
        if (t.getUpperBound() != null) {
            return new TypeExtends(varName, this.handle(t.getUpperBound()));
        }
        if (t.getLowerBound() != null && !(t.getLowerBound() instanceof NullType)) {
            return new TypeSuper(varName, this.handle(t.getLowerBound()));
        }
        return null;
    }

    @Nullable
    private Type handleWildcard(WildcardType t) {
        if (t.getExtendsBound() != null) {
            return new TypeExtends(this.handle(t.getExtendsBound()));
        }
        if (t.getSuperBound() != null) {
            return new TypeSuper(this.handle(t.getSuperBound()));
        }
        return null;
    }

    private boolean isImplemented(TypeElement type, TypeElement iface) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            String name = ((Object)typeMirror).toString();
            if (name.contains("<")) {
                name = name.substring(0, name.indexOf(60));
            }
            if (!name.equals(iface.getQualifiedName().toString())) continue;
            return true;
        }
        if (type.getSuperclass() != null) {
            TypeElement superType = (TypeElement)this.env.getTypeUtils().asElement(type.getSuperclass());
            if (superType != null) {
                return this.isImplemented(superType, iface);
            }
            superType = this.env.getElementUtils().getTypeElement(((Object)type.getSuperclass()).toString());
            if (superType != null) {
                return this.isImplemented(superType, iface);
            }
            return false;
        }
        return false;
    }

    private boolean isSubType(TypeElement type1, TypeElement type2) {
        return this.env.getTypeUtils().isSubtype(type1.asType(), type2.asType());
    }

    private TypeMirror normalize(TypeMirror type) {
        WildcardType wildcard;
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVar = (TypeVariable)type;
            if (typeVar.getUpperBound() != null) {
                return typeVar.getUpperBound();
            }
        } else if (type.getKind() == TypeKind.WILDCARD && (wildcard = (WildcardType)type).getExtendsBound() != null) {
            return wildcard.getExtendsBound();
        }
        return type;
    }
}

