/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log.jdk.hook;

import com.mycila.log.jdk.hook.MycilaInvocationHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncInvocationHandler<T extends Handler>
extends MycilaInvocationHandler<T> {
    private static final AtomicBoolean running = new AtomicBoolean(true);
    private static final BlockingQueue<Runnable> records = new LinkedBlockingQueue<Runnable>();
    private static final Thread logger = new Thread(new Runnable(){

        public void run() {
            while (running.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    Runnable r = (Runnable)records.poll(10L, TimeUnit.SECONDS);
                    if (r == null) continue;
                    r.run();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }, AsyncInvocationHandler.class.getSimpleName() + "-Thread");

    @Override
    public void publish(T handler, LogRecord record) {
        Runnable r = new Runnable((Handler)handler, record){
            final /* synthetic */ Handler val$handler;
            final /* synthetic */ LogRecord val$record;
            {
                this.val$handler = handler;
                this.val$record = logRecord;
            }

            public void run() {
                this.val$handler.publish(this.val$record);
                this.val$handler.flush();
            }
        };
        if (running.get()) {
            records.offer(r);
        } else {
            r.run();
        }
    }

    static {
        logger.setDaemon(true);
        logger.start();
    }
}

