/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log.jdk.format;

import com.mycila.log.jdk.format.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class ClassFormatter
extends Formatter {
    private DateFormat dateFormat;
    private String pattern;

    public ClassFormatter() {
        this.setDatePattern("yyyy-MM-dd HH:mm:ss,SSS");
    }

    public String format(LogRecord record) {
        String src = record.getSourceClassName();
        if (src == null) {
            src = this.notNull(record.getLoggerName());
        }
        StringBuffer sb = new StringBuffer().append(this.dateFormat.format(new Date(record.getMillis()))).append(" ").append(record.getLevel()).append(" [").append(this.notNull(record.getSourceMethodName())).append("]").append(" [").append(this.stripped(this.notNull(src))).append("]").append(" - ").append(record.getMessage()).append(Utils.EOL);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    String stripped(String name) {
        int pos = name.length();
        int count = 2;
        while ((pos = name.lastIndexOf(".", pos - 1)) != -1 && count-- > 0) {
        }
        if (++pos < name.length() && name.charAt(pos) == '.') {
            ++pos;
        }
        return name.substring(pos);
    }

    private String notNull(String s) {
        return s == null ? "?" : s;
    }

    public void setDatePattern(String pattern) {
        this.pattern = pattern;
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public String getDatePattern() {
        return this.pattern;
    }
}

