/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log.jdk;

import com.mycila.log.Logger;
import com.mycila.log.LoggerProvider;
import com.mycila.log.LoggerProviders;
import com.mycila.log.jdk.JDKLogger;
import java.io.IOException;
import java.net.URL;
import java.util.logging.LogManager;

public final class JDKLoggerProvider
implements LoggerProvider {
    private static final LoggerProvider INSTANCE = new JDKLoggerProvider();

    public JDKLoggerProvider() {
        URL config;
        String file = LoggerProviders.getConfigFile();
        if (file == null) {
            file = "logging.properties";
        }
        if ((config = Thread.currentThread().getContextClassLoader().getResource(file)) != null) {
            try {
                LogManager.getLogManager().readConfiguration(config.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public Logger get(String name) {
        return new JDKLogger(name);
    }

    public static LoggerProvider get() {
        return INSTANCE;
    }
}

