/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.log;

import com.mycila.log.Level;
import com.mycila.log.Logger;

public abstract class AbstractLogger
implements Logger {
    public boolean canTrace() {
        return this.canLog(Level.TRACE);
    }

    public final void trace(Object message, Object ... args) {
        if (this.canLog(Level.TRACE)) {
            this.doLog(Level.TRACE, null, message, args);
        }
    }

    public final void trace(Throwable throwable, Object message, Object ... args) {
        if (this.canLog(Level.TRACE)) {
            this.doLog(Level.TRACE, throwable, message, args);
        }
    }

    public final boolean canDebug() {
        return this.canLog(Level.DEBUG);
    }

    public final void debug(Object message, Object ... args) {
        if (this.canLog(Level.DEBUG)) {
            this.doLog(Level.DEBUG, null, message, args);
        }
    }

    public final void debug(Throwable throwable, Object message, Object ... args) {
        if (this.canLog(Level.DEBUG)) {
            this.doLog(Level.DEBUG, throwable, message, args);
        }
    }

    public final boolean canInfo() {
        return this.canLog(Level.INFO);
    }

    public final void info(Object message, Object ... args) {
        if (this.canLog(Level.INFO)) {
            this.doLog(Level.INFO, null, message, args);
        }
    }

    public final void info(Throwable throwable, Object message, Object ... args) {
        if (this.canLog(Level.INFO)) {
            this.doLog(Level.INFO, throwable, message, args);
        }
    }

    public final boolean canWarn() {
        return this.canLog(Level.WARN);
    }

    public final void warn(Object message, Object ... args) {
        if (this.canLog(Level.WARN)) {
            this.doLog(Level.WARN, null, message, args);
        }
    }

    public final void warn(Throwable throwable, Object message, Object ... args) {
        if (this.canLog(Level.WARN)) {
            this.doLog(Level.WARN, throwable, message, args);
        }
    }

    public final boolean canError() {
        return this.canLog(Level.ERROR);
    }

    public final void error(Object message, Object ... args) {
        if (this.canLog(Level.ERROR)) {
            this.doLog(Level.ERROR, null, message, args);
        }
    }

    public final void error(Throwable throwable, Object message, Object ... args) {
        if (this.canLog(Level.ERROR)) {
            this.doLog(Level.ERROR, throwable, message, args);
        }
    }

    public final void log(Level level, Object message, Object ... args) {
        if (this.canLog(level)) {
            this.doLog(level, null, message, args);
        }
    }

    public final void log(Level level, Throwable throwable, Object message, Object ... args) {
        if (this.canLog(level)) {
            this.doLog(level, throwable, message, args);
        }
    }

    public void debug(Object message) {
        if (this.canLog(Level.DEBUG)) {
            this.doLog(Level.DEBUG, null, message, new Object[0]);
        }
    }

    public void debug(Throwable throwable, Object message) {
        if (this.canLog(Level.DEBUG)) {
            this.doLog(Level.DEBUG, throwable, message, new Object[0]);
        }
    }

    public void error(Object message) {
        if (this.canLog(Level.ERROR)) {
            this.doLog(Level.ERROR, null, message, new Object[0]);
        }
    }

    public void error(Throwable throwable, Object message) {
        if (this.canLog(Level.ERROR)) {
            this.doLog(Level.ERROR, throwable, message, new Object[0]);
        }
    }

    public void info(Object message) {
        if (this.canLog(Level.INFO)) {
            this.doLog(Level.INFO, null, message, new Object[0]);
        }
    }

    public void info(Throwable throwable, Object message) {
        if (this.canLog(Level.INFO)) {
            this.doLog(Level.INFO, throwable, message, new Object[0]);
        }
    }

    public void log(Level level, Object message) {
        if (this.canLog(level)) {
            this.doLog(level, null, message, new Object[0]);
        }
    }

    public void log(Level level, Throwable throwable, Object message) {
        if (this.canLog(level)) {
            this.doLog(level, throwable, message, new Object[0]);
        }
    }

    public void trace(Object message) {
        if (this.canLog(Level.TRACE)) {
            this.doLog(Level.TRACE, null, message, new Object[0]);
        }
    }

    public void trace(Throwable throwable, Object message) {
        if (this.canLog(Level.TRACE)) {
            this.doLog(Level.TRACE, throwable, message, new Object[0]);
        }
    }

    public void warn(Object message) {
        if (this.canLog(Level.WARN)) {
            this.doLog(Level.WARN, null, message, new Object[0]);
        }
    }

    public void warn(Throwable throwable, Object message) {
        if (this.canLog(Level.WARN)) {
            this.doLog(Level.WARN, throwable, message, new Object[0]);
        }
    }

    protected abstract void doLog(Level var1, Throwable var2, Object var3, Object ... var4);
}

