/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.util;

import com.mycila.inject.util.Loader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class DefaultLoader
implements Loader {
    private final ClassLoader classLoader;

    public DefaultLoader() {
        this(DefaultLoader.getDefaultClassLoader());
    }

    public DefaultLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to load class " + className, e);
        }
    }

    @Override
    public URL getResource(String path) {
        return this.classLoader.getResource(path);
    }

    @Override
    public List<URL> getResources(String path) {
        LinkedList<URL> urls = new LinkedList<URL>();
        try {
            Enumeration<URL> e = this.classLoader.getResources(path);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return urls;
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = DefaultLoader.class.getClassLoader();
        }
        return cl;
    }
}

