/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.guava.base;

import com.mycila.inject.internal.guava.annotations.GwtCompatible;
import com.mycila.inject.internal.guava.base.Joiner;
import com.mycila.inject.internal.guava.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(Objects.simpleName(self.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int start = name.lastIndexOf(36);
        if (start == -1) {
            start = name.lastIndexOf(46);
        }
        return name.substring(start + 1);
    }

    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        return first != null ? first : Preconditions.checkNotNull(second);
    }

    public static class ToStringHelper {
        private final List<String> fieldString = new ArrayList<String>();
        private final String className;
        private static final Joiner JOINER = Joiner.on(", ");

        private ToStringHelper(String className) {
            this.className = Preconditions.checkNotNull(className);
        }

        public ToStringHelper add(String name, @Nullable Object value) {
            return this.addValue(Preconditions.checkNotNull(name) + "=" + value);
        }

        public ToStringHelper addValue(@Nullable Object value) {
            this.fieldString.add(String.valueOf(value));
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(100).append(this.className).append('{');
            return JOINER.appendTo(builder, (Iterable<?>)this.fieldString).append('}').toString();
        }
    }
}

