/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal.cglib.transform.impl;

import com.mycila.inject.internal.asm.Type;
import com.mycila.inject.internal.cglib.core.CodeEmitter;
import com.mycila.inject.internal.cglib.core.CodeGenerationException;
import com.mycila.inject.internal.cglib.core.ReflectUtils;
import com.mycila.inject.internal.cglib.core.Signature;
import com.mycila.inject.internal.cglib.core.TypeUtils;
import com.mycila.inject.internal.cglib.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class AddDelegateTransformer
extends ClassEmitterTransformer {
    private static final String DELEGATE = "$CGLIB_DELEGATE";
    private static final Signature CSTRUCT_OBJECT = TypeUtils.parseSignature("void <init>(Object)");
    private Class[] delegateIf;
    private Class delegateImpl;
    private Type delegateType;
    static /* synthetic */ Class class$java$lang$Object;

    public AddDelegateTransformer(Class[] delegateIf, Class delegateImpl) {
        try {
            delegateImpl.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = AddDelegateTransformer.class$("java.lang.Object")) : class$java$lang$Object);
            this.delegateIf = delegateIf;
            this.delegateImpl = delegateImpl;
            this.delegateType = Type.getType(delegateImpl);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    public void begin_class(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!TypeUtils.isInterface(access)) {
            Type[] all = TypeUtils.add(interfaces, TypeUtils.getTypes(this.delegateIf));
            super.begin_class(version, access, className, superType, all, sourceFile);
            this.declare_field(130, DELEGATE, this.delegateType, null);
            for (int i = 0; i < this.delegateIf.length; ++i) {
                Method[] methods = this.delegateIf[i].getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    if (!Modifier.isAbstract(methods[j].getModifiers())) continue;
                    this.addDelegate(methods[j]);
                }
            }
        } else {
            super.begin_class(version, access, className, superType, interfaces, sourceFile);
        }
    }

    public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions) {
        CodeEmitter e = super.begin_method(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(e){
                private boolean transformInit = true;

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    super.visitMethodInsn(opcode, owner, name, desc);
                    if (this.transformInit && opcode == 183) {
                        this.load_this();
                        this.new_instance(AddDelegateTransformer.this.delegateType);
                        this.dup();
                        this.load_this();
                        this.invoke_constructor(AddDelegateTransformer.this.delegateType, CSTRUCT_OBJECT);
                        this.putfield(AddDelegateTransformer.DELEGATE);
                        this.transformInit = false;
                    }
                }
            };
        }
        return e;
    }

    private void addDelegate(Method m) {
        try {
            Method delegate = this.delegateImpl.getMethod(m.getName(), m.getParameterTypes());
            if (!delegate.getReturnType().getName().equals(m.getReturnType().getName())) {
                throw new IllegalArgumentException("Invalid delegate signature " + delegate);
            }
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
        Signature sig = ReflectUtils.getSignature(m);
        Type[] exceptions = TypeUtils.getTypes(m.getExceptionTypes());
        CodeEmitter e = super.begin_method(1, sig, exceptions);
        e.load_this();
        e.getfield(DELEGATE);
        e.load_args();
        e.invoke_virtual(this.delegateType, sig);
        e.return_value();
        e.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

