/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.inject.internal;

import com.mycila.inject.internal.cglib.core.DefaultNamingPolicy;
import com.mycila.inject.internal.cglib.core.NamingPolicy;
import com.mycila.inject.internal.cglib.proxy.Enhancer;
import com.mycila.inject.internal.cglib.reflect.FastClass;
import com.mycila.inject.internal.guava.base.Function;
import com.mycila.inject.internal.guava.collect.MapMaker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

final class BytecodeGen {
    private static final ClassLoader MYCILA_CLASS_LOADER = BytecodeGen.canonicalize(BytecodeGen.class.getClassLoader());
    private static final String MYCILA_INTERNAL_PACKAGE = BytecodeGen.class.getName().replaceFirst("\\.internal\\..*$", ".internal");
    private static final String CGLIB_PACKAGE = Enhancer.class.getName().replaceFirst("\\.cglib\\..*$", ".cglib");
    private static final NamingPolicy NAMING_POLICY = new DefaultNamingPolicy(){

        @Override
        protected String getTag() {
            return "ByMycila";
        }
    };
    private static final Map<ClassLoader, ClassLoader> CLASS_LOADER_CACHE = new MapMaker().weakKeys().weakValues().makeComputingMap(new Function<ClassLoader, ClassLoader>(){

        @Override
        public ClassLoader apply(final ClassLoader typeClassLoader) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new BridgeClassLoader(typeClassLoader);
                }
            });
        }
    });

    BytecodeGen() {
    }

    private static ClassLoader canonicalize(ClassLoader classLoader) {
        return classLoader != null ? classLoader : SystemBridgeHolder.SYSTEM_BRIDGE.getParent();
    }

    public static ClassLoader getClassLoader(Class<?> type) {
        return BytecodeGen.getClassLoader(type, type.getClassLoader());
    }

    private static ClassLoader getClassLoader(Class<?> type, ClassLoader delegate) {
        if (type.getName().startsWith("java.")) {
            return MYCILA_CLASS_LOADER;
        }
        if ((delegate = BytecodeGen.canonicalize(delegate)) == MYCILA_CLASS_LOADER || delegate instanceof BridgeClassLoader) {
            return delegate;
        }
        if (Visibility.forType(type) == Visibility.PUBLIC) {
            if (delegate != SystemBridgeHolder.SYSTEM_BRIDGE.getParent()) {
                return CLASS_LOADER_CACHE.get(delegate);
            }
            return SystemBridgeHolder.SYSTEM_BRIDGE;
        }
        return delegate;
    }

    public static FastClass newFastClass(Class<?> type, Visibility visibility) {
        FastClass.Generator generator = new FastClass.Generator();
        generator.setType(type);
        if (visibility == Visibility.PUBLIC) {
            generator.setClassLoader(BytecodeGen.getClassLoader(type));
        }
        generator.setNamingPolicy(NAMING_POLICY);
        return generator.create();
    }

    public static Enhancer newEnhancer(Class<?> type, Visibility visibility) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setUseFactory(false);
        if (visibility == Visibility.PUBLIC) {
            enhancer.setClassLoader(BytecodeGen.getClassLoader(type));
        }
        enhancer.setNamingPolicy(NAMING_POLICY);
        return enhancer;
    }

    private static class BridgeClassLoader
    extends ClassLoader {
        BridgeClassLoader() {
        }

        BridgeClassLoader(ClassLoader usersClassLoader) {
            super(usersClassLoader);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("sun.reflect")) {
                return SystemBridgeHolder.SYSTEM_BRIDGE.classicLoadClass(name, resolve);
            }
            if (name.startsWith(MYCILA_INTERNAL_PACKAGE) || name.startsWith(CGLIB_PACKAGE)) {
                if (null == MYCILA_CLASS_LOADER) {
                    return SystemBridgeHolder.SYSTEM_BRIDGE.classicLoadClass(name, resolve);
                }
                try {
                    Class<?> clazz = MYCILA_CLASS_LOADER.loadClass(name);
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.classicLoadClass(name, resolve);
        }

        Class<?> classicLoadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }

    public static enum Visibility {
        PUBLIC{

            @Override
            public Visibility and(Visibility that) {
                return that;
            }
        }
        ,
        SAME_PACKAGE{

            @Override
            public Visibility and(Visibility that) {
                return this;
            }
        };


        public static Visibility forMember(Member member) {
            Class<?>[] parameterTypes;
            if ((member.getModifiers() & 5) == 0) {
                return SAME_PACKAGE;
            }
            for (Class<?> type : parameterTypes = member instanceof Constructor ? ((Constructor)member).getParameterTypes() : ((Method)member).getParameterTypes()) {
                if (Visibility.forType(type) != SAME_PACKAGE) continue;
                return SAME_PACKAGE;
            }
            return PUBLIC;
        }

        public static Visibility forType(Class<?> type) {
            return (type.getModifiers() & 5) != 0 ? PUBLIC : SAME_PACKAGE;
        }

        public abstract Visibility and(Visibility var1);
    }

    private static class SystemBridgeHolder {
        static final BridgeClassLoader SYSTEM_BRIDGE = new BridgeClassLoader();

        private SystemBridgeHolder() {
        }
    }
}

