/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.connector.cci;

import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;

public class MockLocalTransaction
implements LocalTransaction {
    private boolean beginCalled;
    private boolean commitCalled;
    private boolean rollbackCalled;
    private int beginCalls;
    private int commitCalls;
    private int rollbackCalls;

    public MockLocalTransaction() {
        this.reset();
    }

    public void reset() {
        this.beginCalled = false;
        this.commitCalled = false;
        this.rollbackCalled = false;
        this.beginCalls = 0;
        this.commitCalls = 0;
        this.rollbackCalls = 0;
    }

    public void begin() throws ResourceException {
        this.beginCalled = true;
        this.commitCalled = false;
        this.rollbackCalled = false;
        ++this.beginCalls;
    }

    public void commit() throws ResourceException {
        this.commitCalled = true;
        ++this.commitCalls;
    }

    public void rollback() throws ResourceException {
        this.rollbackCalled = true;
        ++this.rollbackCalls;
    }

    public boolean wasBeginCalled() {
        return this.beginCalled;
    }

    public boolean wasCommitCalled() {
        return this.commitCalled;
    }

    public boolean wasRollbackCalled() {
        return this.rollbackCalled;
    }

    public int getNumberBeginCalls() {
        return this.beginCalls;
    }

    public int getNumberCommitCalls() {
        return this.commitCalls;
    }

    public int getNumberRollbackCalls() {
        return this.rollbackCalls;
    }
}

