/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XMLResultSetFactory
implements ResultSetFactory {
    public static final int SYBASE_DIALECT = 0;
    private File file = null;
    private String fileName = null;
    private boolean trim = true;
    private int dialect = 0;

    public XMLResultSetFactory(String string) {
        this.file = new File(string);
        this.fileName = string;
    }

    public XMLResultSetFactory(File file) {
        this.file = file;
        this.fileName = file.getAbsolutePath();
    }

    public MockResultSet create(String string) {
        MockResultSet mockResultSet;
        switch (this.dialect) {
            case 0: {
                mockResultSet = this.createSybaseResultSet(string);
                break;
            }
            default: {
                mockResultSet = this.createSybaseResultSet(string);
            }
        }
        return mockResultSet;
    }

    public File getXMLFile() {
        if (this.file.exists() && this.file.isFile()) {
            return this.file;
        }
        try {
            this.file = FileUtil.findFile(this.file.getPath());
            return this.file;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Could not find: " + this.file.getPath());
        }
    }

    public void setTrim(boolean bl) {
        this.trim = bl;
    }

    public boolean getTrim() {
        return this.trim;
    }

    public void setDialect(int n) {
        this.dialect = 0;
    }

    public int getDialect() {
        return this.dialect;
    }

    public MockResultSet createSybaseResultSet(String string) {
        MockResultSet mockResultSet = new MockResultSet(string);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = null;
        File file = this.getXMLFile();
        if (null == file) {
            throw new RuntimeException("File " + this.fileName + " not found.");
        }
        try {
            document = sAXBuilder.build(file);
            Element element = document.getRootElement();
            List list = element.getChildren("row");
            Iterator iterator = list.iterator();
            boolean bl = true;
            int n = 0;
            while (iterator.hasNext()) {
                Object[] objectArray;
                Element element2 = (Element)iterator.next();
                Object[] objectArray2 = element2.getChildren();
                Iterator iterator2 = objectArray2.iterator();
                if (bl) {
                    objectArray = objectArray2;
                    for (Element element3 : objectArray) {
                        mockResultSet.addColumn(element3.getName());
                        ++n;
                    }
                    bl = false;
                }
                objectArray = new String[n];
                int n2 = 0;
                while (iterator2.hasNext()) {
                    Element element4 = (Element)iterator2.next();
                    String string2 = this.trim ? element4.getTextTrim() : element4.getText();
                    objectArray[n2] = string2;
                    ++n2;
                }
                mockResultSet.addRow(objectArray);
            }
        }
        catch (Exception exception) {
            throw new NestedApplicationException("Failure while reading from XML file", exception);
        }
        return mockResultSet;
    }
}

