/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.resourcemanager.resources.ResourceManager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ResourcesServiceSubscription
extends AbstractAzServiceSubscription<ResourcesServiceSubscription, ResourceManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final ResourceGroupModule groupModule;

    ResourcesServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureResources service) {
        super(subscriptionId, service);
        this.subscriptionId = subscriptionId;
        this.groupModule = new ResourceGroupModule(this);
    }

    ResourcesServiceSubscription(@Nonnull ResourceManager remote, @Nonnull AzureResources service) {
        this(remote.subscriptionId(), service);
    }

    @Override
    @Nonnull
    public List<AbstractAzResourceModule<?, ResourcesServiceSubscription, ?>> getSubModules() {
        return Collections.singletonList(this.groupModule);
    }

    @Nonnull
    public ResourceGroupModule resourceGroups() {
        return this.groupModule;
    }

    @Nonnull
    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.groupModule.getName());
    }

    @Override
    @Nonnull
    public ResourceManager getResourceManager() {
        return Objects.requireNonNull((ResourceManager)this.getRemote(new boolean[0])).resourceManager();
    }

    @Override
    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    public ResourceGroupModule getGroupModule() {
        return this.groupModule;
    }
}

